/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.cef.htmlpages;

import fr.exemole.bdfext.cef.htmlpages.CefHtmlPage;
import fr.exemole.bdfext.cef.htmlpages.CefHtmlPrinter;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.tools.exportation.table.BdfTableExportUtils;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.Item;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.exportation.table.CellConverter;
import net.fichotheque.exportation.table.ColDef;
import net.fichotheque.exportation.table.SubsetTable;
import net.fichotheque.exportation.table.SumCellConverter;
import net.fichotheque.exportation.table.TableDef;
import net.fichotheque.extraction.ExtractionContext;
import net.fichotheque.format.SourceLabelProvider;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.tools.exportation.table.SubsetTableBuilder;
import net.fichotheque.tools.exportation.table.TableExportEngine;
import net.fichotheque.utils.FichothequeUtils;
import net.fichotheque.utils.TableDefUtils;
import net.fichotheque.utils.pointeurs.PointeurFactory;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.money.Amount;
import net.mapeadores.util.primitives.Decimal;
import net.mapeadores.util.primitives.FuzzyDate;
import net.mapeadores.util.table.TableWriter;

public class LogistiquePage
extends CefHtmlPage {
    private final SourceLabelProvider sourceLabelProvider;
    private final BdfParameters bdfParameters;
    private TableDef tableDef;
    private Corpus personneCorpus;
    private Corpus logistiqueCorpus;
    private FieldKey numeroFieldKey;
    private List<SubsetItem> subsetItemList;
    private SubsetTable subsetTable;

    public LogistiquePage(BdfParameters bdfParameters, TableDef tableDef) {
        super(bdfParameters);
        this.tableDef = tableDef;
        this.bdfParameters = bdfParameters;
        this.personneCorpus = FichothequeUtils.getCorpus((Fichotheque)this.fichotheque, (String)"personne");
        this.logistiqueCorpus = FichothequeUtils.getCorpus((Fichotheque)this.fichotheque, (String)"logistique");
        this.numeroFieldKey = FieldKey.build((short)1, (String)"numeroordre");
        this.sourceLabelProvider = this.bdfServer.getTableExportContext().getSourceLabelProvider();
        this.init();
    }

    private void init() {
        FichePointeur fichePointeur = PointeurFactory.newFichePointeur((Corpus)this.logistiqueCorpus);
        ArrayList<PersonneBundle> list = new ArrayList<PersonneBundle>();
        for (FicheMeta ficheMeta : this.logistiqueCorpus.getFicheMetaList()) {
            fichePointeur.setCurrentSubsetItem((SubsetItem)ficheMeta);
            FicheItem ficheItem = (FicheItem)fichePointeur.getValue(this.numeroFieldKey);
            NumeroOrdre numeroOrdre = new NumeroOrdre();
            if (ficheItem != null && ficheItem instanceof Item) {
                numeroOrdre.init(((Item)ficheItem).getValue());
            }
            FicheMeta personne = this.personneCorpus.getFicheMetaById(ficheMeta.getId());
            list.add(new PersonneBundle(personne, numeroOrdre));
        }
        Collections.sort(list, new BundleComparator());
        this.subsetItemList = this.toSubsetItemList(list);
        this.subsetTable = SubsetTableBuilder.init((Subset)this.personneCorpus).populate(this.tableDef, this.bdfServer.getTableExportContext()).toSubsetTable();
    }

    @Override
    public CefHtmlPrinter getCefHtmlPrinter() {
        return new LogistiquePrinter();
    }

    private List<SubsetItem> toSubsetItemList(List<PersonneBundle> list) {
        ArrayList<SubsetItem> result = new ArrayList<SubsetItem>();
        for (PersonneBundle personneBundle : list) {
            result.add((SubsetItem)personneBundle.ficheMeta);
        }
        return result;
    }

    private static class NumeroOrdre
    implements Comparable {
        private int numero = 999999999;
        private String chaine = "";

        private NumeroOrdre() {
        }

        private void init(String s) {
            int length = s.length();
            int idx = -1;
            for (int i = 0; i < length; ++i) {
                char carac = s.charAt(i);
                if (carac >= '0' && carac <= '9') continue;
                idx = i;
                break;
            }
            if (idx == -1) {
                this.numero = Integer.parseInt(s);
            } else if (idx > 0) {
                this.numero = Integer.parseInt(s.substring(0, idx));
                this.chaine = s.substring(idx).trim();
            } else {
                this.chaine = s;
            }
        }

        public int hashCode() {
            return this.numero + this.chaine.hashCode();
        }

        public int compareTo(Object other) {
            NumeroOrdre on = (NumeroOrdre)other;
            if (this.numero < on.numero) {
                return -1;
            }
            if (this.numero > on.numero) {
                return 1;
            }
            return this.chaine.compareTo(on.chaine);
        }
    }

    private static class PersonneBundle {
        FicheMeta ficheMeta;
        NumeroOrdre numeroOrdre;

        PersonneBundle(FicheMeta ficheMeta, NumeroOrdre numeroOrdre) {
            this.ficheMeta = ficheMeta;
            this.numeroOrdre = numeroOrdre;
        }
    }

    private static class BundleComparator
    implements Comparator {
        private BundleComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            return ((PersonneBundle)obj1).numeroOrdre.compareTo(((PersonneBundle)obj2).numeroOrdre);
        }
    }

    private class LogistiquePrinter
    extends CefHtmlPrinter {
        private LogistiquePrinter() {
        }

        @Override
        public void printPage() {
            this.start(LogistiquePage.this.workingLang, "CEF");
            this.TABLE("Logistique");
            this.THEAD();
            this.TR();
            List colDefList = LogistiquePage.this.subsetTable.getColDefList();
            int count = colDefList.size();
            int idColumnNumber = -1;
            for (int i = 0; i < count; ++i) {
                ColDef colDef = (ColDef)colDefList.get(i);
                if (colDef.getColName().equals("id") || colDef.getColName().equals("idcorpus")) {
                    idColumnNumber = i + 1;
                }
                this.TD().__escape((CharSequence)TableDefUtils.getColTitle((ColDef)colDef, (Lang)LogistiquePage.this.workingLang, (SourceLabelProvider)LogistiquePage.this.sourceLabelProvider, (Subset)LogistiquePage.this.personneCorpus))._TD();
            }
            this._TR();
            this._THEAD();
            ExtractionContext extractionContext = LogistiquePage.this.bdfParameters.getDefaultExtractionContext();
            SumCellConverter cellConverter = BdfTableExportUtils.toCellConverter((BdfServer)LogistiquePage.this.bdfServer, (ExtractionContext)extractionContext, (SubsetTable)LogistiquePage.this.subsetTable);
            TableExportEngine.exportSubset((SubsetTable)LogistiquePage.this.subsetTable, (TableWriter)new InternalWriter((HtmlPrinter)this, idColumnNumber, new DecimalFormatSymbols(LogistiquePage.this.bdfUser.getFormatLocale())), (CellConverter)cellConverter, (Collection)LogistiquePage.this.subsetItemList);
            this._TABLE();
            this.end();
        }
    }

    private static class InternalWriter
    implements TableWriter {
        private final HtmlPrinter hp;
        private final DecimalFormatSymbols symbols;
        private final int idColumnNumber;
        private int columnNumber;
        private int rowNumber;

        private InternalWriter(HtmlPrinter hp, int idColumnNumber, DecimalFormatSymbols symbols) {
            this.hp = hp;
            this.idColumnNumber = idColumnNumber;
            this.symbols = symbols;
            this.rowNumber = 0;
        }

        public int startRow() {
            ++this.rowNumber;
            this.hp.TR();
            this.columnNumber = 0;
            return this.rowNumber;
        }

        public int addIntegerCell(Long lg) {
            ++this.columnNumber;
            boolean id = false;
            if (this.columnNumber == this.idColumnNumber) {
                id = true;
            }
            this.hp.TD();
            if (lg != null) {
                if (id) {
                    this.hp.SPAN("Id");
                }
                this.hp.__append(lg.longValue());
                if (id) {
                    this.hp._SPAN();
                }
            }
            this.hp._TD();
            return this.columnNumber;
        }

        public int addDecimalCell(Decimal decimal) {
            ++this.columnNumber;
            this.hp.TD();
            if (decimal != null) {
                this.hp.__escape((Object)decimal);
            }
            this.hp._TD();
            return this.columnNumber;
        }

        public int addStringCell(String s) {
            ++this.columnNumber;
            this.hp.TD();
            if (s != null) {
                this.hp.__escape((CharSequence)s);
            }
            this.hp._TD();
            return this.columnNumber;
        }

        public int addDateCell(FuzzyDate date) {
            ++this.columnNumber;
            this.hp.TD();
            if (date != null) {
                this.hp.__escape((CharSequence)date.toISOString());
            }
            this.hp._TD();
            return this.columnNumber;
        }

        public int addMoneyCell(Amount amount) {
            ++this.columnNumber;
            this.hp.TD();
            if (amount != null) {
                this.hp.__escape((CharSequence)amount.toLitteralString(this.symbols, false));
            }
            this.hp._TD();
            return this.columnNumber;
        }

        public int addPercentageCell(Decimal decimal) {
            ++this.columnNumber;
            this.hp.TD();
            if (decimal != null) {
                this.hp.__escape((Object)decimal);
            }
            this.hp._TD();
            return this.columnNumber;
        }

        public int endRow() {
            this.hp._TR();
            return this.rowNumber;
        }
    }
}

