/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.cef.actions;

import fr.exemole.bdfext.cef.htmlpages.PersonneAtelierParFonction;
import fr.exemole.bdfext.cef.htmlpages.PersonneAtelierParFonctionMap;
import fr.exemole.bdfserver.api.BdfServer;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.croisement.Croisements;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.instruction.Argument;
import net.mapeadores.util.instruction.Instruction;
import net.mapeadores.util.instruction.InstructionResolver;
import net.mapeadores.util.logging.ErrorMessageException;

public class ParticipantsAction {
    private static final SubsetKey atelier2007CorpusKey = SubsetKey.build((String)"corpus_atelier");
    private static final SubsetKey personneatelier2009CorpusKey = SubsetKey.build((String)"corpus_personneatelier2009");
    private static final SubsetKey personneatelier2010CorpusKey = SubsetKey.build((String)"corpus_personneatelier2010");
    private static final SubsetKey personneCorpusKey = SubsetKey.build((String)"corpus_personne");
    private static final SubsetKey fonctionThesaurusKey = SubsetKey.build((String)"thesaurus_fonction0809");
    private final BdfServer bdfServer;
    private final Corpus atelier2007Corpus;
    private final Thesaurus atelierThesaurus;
    private final Corpus personneatelier2009Corpus;
    private final Corpus personneatelier2010Corpus;
    private final Corpus personneCorpus;
    private final Fichotheque fichotheque;
    private final Set<Integer> personneSet = new TreeSet<Integer>();
    private final Thesaurus fonctionThesaurus;

    public ParticipantsAction(BdfServer bdfServer) {
        this.bdfServer = bdfServer;
        this.fichotheque = bdfServer.getFichotheque();
        this.atelier2007Corpus = (Corpus)this.fichotheque.getSubset(atelier2007CorpusKey);
        this.personneCorpus = (Corpus)this.fichotheque.getSubset(personneCorpusKey);
        this.atelierThesaurus = FichothequeUtils.getThesaurus((Fichotheque)this.fichotheque, (String)"atelierpermanent");
        this.personneatelier2009Corpus = (Corpus)this.fichotheque.getSubset(personneatelier2009CorpusKey);
        this.personneatelier2010Corpus = (Corpus)this.fichotheque.getSubset(personneatelier2010CorpusKey);
        this.fonctionThesaurus = (Thesaurus)this.fichotheque.getSubset(fonctionThesaurusKey);
    }

    public void doAction() {
        this.check2007();
        for (Motcle motcle : this.atelierThesaurus.getMotcleList()) {
            Croisements croisements2010;
            Croisements croisements2009 = this.fichotheque.getCroisements((SubsetItem)motcle, (Subset)this.personneatelier2009Corpus);
            if (!croisements2009.isEmpty()) {
                this.checkPersonneAtelierList(croisements2009, this.personneatelier2009Corpus);
            }
            if ((croisements2010 = this.fichotheque.getCroisements((SubsetItem)motcle, (Subset)this.personneatelier2010Corpus)).isEmpty()) continue;
            this.checkPersonneAtelierList(croisements2010, this.personneatelier2010Corpus);
        }
    }

    private void check2007() {
        for (FicheMeta ficheMeta : this.atelier2007Corpus.getFicheMetaList()) {
            Croisements ficheCroisements = this.fichotheque.getCroisements((SubsetItem)ficheMeta, (Subset)this.personneCorpus);
            for (Croisements.Entry entry : ficheCroisements.getEntryList()) {
                this.personneSet.add(entry.getSubsetItem().getId());
            }
        }
    }

    private void checkPersonneAtelierList(Croisements list, Corpus personneatelierCorpus) {
        PersonneAtelierParFonctionMap map = new PersonneAtelierParFonctionMap(personneatelierCorpus, this.fonctionThesaurus);
        map.build(list);
        for (PersonneAtelierParFonction papf : map.getFonctionMap().values()) {
            List<FicheMeta> personneAtelierList = papf.getPersonneAtelierList(8);
            for (FicheMeta personneAtelier : personneAtelierList) {
                Croisements personneCroisements = this.fichotheque.getCroisements((SubsetItem)personneAtelier, (Subset)this.personneCorpus);
                if (personneCroisements.isEmpty()) continue;
                this.personneSet.add(personneCroisements.getFirstSubsetItem().getId());
            }
        }
    }

    public InstructionResolver getResultValueResolver() {
        return new ResultGabaritResolver();
    }

    private class ResultGabaritResolver
    implements InstructionResolver {
        private ResultGabaritResolver() {
        }

        public Object resolve(Instruction instruction) throws ErrorMessageException {
            String name = ((Argument)instruction.get(0)).getKey();
            if (name.equals("LIST")) {
                StringBuilder stringBuilder = new StringBuilder();
                for (Integer itg : ParticipantsAction.this.personneSet) {
                    stringBuilder.append(itg.toString());
                    stringBuilder.append("; ");
                }
                return stringBuilder.toString();
            }
            return instruction.toString();
        }
    }
}

