/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.cef;

import fr.exemole.bdfext.cef.Cef;
import fr.exemole.bdfext.cef.actions.ParticipantsAction;
import fr.exemole.bdfext.cef.htmlpages.AccueilPage;
import fr.exemole.bdfext.cef.htmlpages.AtelierPage;
import fr.exemole.bdfext.cef.htmlpages.CadrePage;
import fr.exemole.bdfext.cef.htmlpages.HierarchiePage;
import fr.exemole.bdfext.cef.htmlpages.LogistiquePage;
import fr.exemole.bdfext.cef.htmlpages.MenuPage;
import fr.exemole.bdfext.cef.htmlpages.RecapitulatifGabaritResolver;
import fr.exemole.bdfext.cef.htmlpages.RepartitionPage;
import fr.exemole.bdfext.cef.htmlpages.StatutPage;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfInstruction;
import fr.exemole.bdfserver.api.instruction.BdfInstructionConstants;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.tools.instruction.DefaultBdfParameters;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.exportation.table.TableDef;
import net.fichotheque.exportation.table.TableExportContext;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.tools.exportation.table.TableDefParser;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.exceptions.NestedIOException;
import net.mapeadores.util.html.GabaritHtmlProducer;
import net.mapeadores.util.html.HtmlProducer;
import net.mapeadores.util.instruction.InstructionResolver;
import net.mapeadores.util.io.DocStream;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.json.JsonProducer;
import net.mapeadores.util.logging.LineMessageHandler;
import net.mapeadores.util.logging.LogUtils;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.servlets.ResponseHandler;
import net.mapeadores.util.servlets.handlers.HtmlResponseHandler;
import net.mapeadores.util.servlets.handlers.JsonResponseHandler;
import net.mapeadores.util.servlets.handlers.SimpleResponseHandler;
import net.mapeadores.util.text.RelativePath;

public class CefBdfInstruction
implements BdfInstruction,
BdfInstructionConstants {
    private final Map<String, String> paramMap;
    private final BdfServer bdfServer;
    private final RequestMap requestMap;
    private BdfUser bdfUser;
    private final Fichotheque fichotheque;
    private HtmlProducer htmlProducer = null;
    private final JsonProducer jsonProducer = null;
    private String errorMessage;

    public CefBdfInstruction(BdfServer bdfServer, RequestMap requestMap, Map<String, String> paramMap) {
        this.paramMap = paramMap;
        this.bdfServer = bdfServer;
        this.fichotheque = bdfServer.getFichotheque();
        this.requestMap = requestMap;
    }

    public short getBdfUserNeed() {
        return 3;
    }

    public ResponseHandler runInstruction(BdfUser bdfUser) {
        this.bdfUser = bdfUser;
        this.init();
        if (this.htmlProducer != null) {
            return HtmlResponseHandler.init((HtmlProducer)this.htmlProducer);
        }
        if (this.jsonProducer != null) {
            return JsonResponseHandler.build((JsonProducer)this.jsonProducer, (RequestMap)this.requestMap);
        }
        if (this.errorMessage != null) {
            return SimpleResponseHandler.init((String)this.errorMessage);
        }
        return null;
    }

    private void init() {
        DefaultBdfParameters bdfParameters = new DefaultBdfParameters(this.bdfServer, this.bdfUser);
        String page = this.paramMap.get("page");
        if (page.equals("atelier")) {
            String idalpha = this.paramMap.get("atelier");
            Thesaurus thesaurus = FichothequeUtils.getThesaurus((Fichotheque)this.fichotheque, (String)"atelierpermanent");
            Motcle atelier = thesaurus.getMotcleByIdalpha(idalpha);
            if (atelier == null) {
                return;
            }
            AtelierPage atelierPage = new AtelierPage(this.bdfServer, this.bdfUser, atelier);
            this.htmlProducer = atelierPage;
        } else if (page.equals("hierarchie")) {
            String mode = this.paramMap.get("mode");
            this.htmlProducer = new HierarchiePage(this.bdfServer, this.bdfUser, mode);
        } else if (page.equals("accueil")) {
            this.htmlProducer = new AccueilPage(this.bdfServer, this.bdfUser);
        } else if (page.equals("cadre")) {
            this.htmlProducer = new CadrePage(this.bdfServer, this.bdfUser);
        } else if (page.equals("menu")) {
            List<String> list = this.getLogistiqueList();
            this.htmlProducer = new MenuPage(this.bdfServer, this.bdfUser, list);
        } else if (page.equals("statut")) {
            this.htmlProducer = new StatutPage(this.bdfServer, this.bdfUser);
        } else if (page.equals("logistique")) {
            String tableau = this.paramMap.get("tableau");
            Corpus personneCorpus = FichothequeUtils.getCorpus((Fichotheque)this.fichotheque, (String)"personne");
            TableDef colDefList = this.getTableDef("logistique-" + tableau, personneCorpus);
            if (colDefList == null) {
                return;
            }
            this.htmlProducer = new LogistiquePage((BdfParameters)bdfParameters, colDefList);
        } else if (page.equals("repartition")) {
            String continent = this.paramMap.get("continent");
            if (!continent.equals("EU") && !continent.equals("CN")) {
                return;
            }
            Corpus personneCorpus = FichothequeUtils.getCorpus((Fichotheque)this.fichotheque, (String)"personne");
            TableDef colDefList = this.getTableDef("repartition", personneCorpus);
            if (colDefList == null) {
                return;
            }
            this.htmlProducer = new RepartitionPage((BdfParameters)bdfParameters, colDefList, continent);
        } else {
            if (page.equals("recapitulatif")) {
                String idalpha = this.paramMap.get("atelier");
                Thesaurus thesaurus = FichothequeUtils.getThesaurus((Fichotheque)this.fichotheque, (String)"atelierpermanent");
                Motcle atelier = thesaurus.getMotcleByIdalpha(idalpha);
                if (atelier == null) {
                    this.errorMessage = "Atelier inconnu : " + idalpha;
                    return;
                }
                try {
                    String gabaritString = this.getGabarit("recapitulatif");
                    RecapitulatifGabaritResolver recapitulatifGabaritResolver = new RecapitulatifGabaritResolver(this.bdfServer, this.bdfUser.getWorkingLang(), atelier);
                    this.htmlProducer = new GabaritHtmlProducer(gabaritString, (InstructionResolver)recapitulatifGabaritResolver);
                }
                catch (IOException ioe) {
                    throw new NestedIOException(ioe);
                }
            }
            if (page.equals("action")) {
                String action = this.paramMap.get("action");
                String gabaritString = null;
                try {
                    gabaritString = this.getGabarit("action-" + action);
                }
                catch (IOException ioe) {
                    throw new NestedIOException(ioe);
                }
                InstructionResolver instructionResolver = this.doAction(action);
                if (instructionResolver == null) {
                    this.errorMessage = "Action inconnue = " + action;
                } else if (gabaritString == null) {
                    this.errorMessage = "Gabarit inconnu = action-" + action;
                } else {
                    this.htmlProducer = new GabaritHtmlProducer(gabaritString, instructionResolver);
                }
            }
        }
    }

    private String getGabarit(String type) throws IOException {
        DocStream docStream = this.bdfServer.getResourceStorages().getResourceDocStream(Cef.EXTENSION_RESOURCE_ROOT.buildChild("private/" + type + ".html"));
        if (docStream == null) {
            return null;
        }
        try (InputStream is = docStream.getInputStream();){
            String string = IOUtils.toString((InputStream)is, (String)"UTF-8");
            return string;
        }
    }

    private TableDef getTableDef(String name, Corpus corpus) {
        TableDef tableDef;
        DocStream docStream = this.bdfServer.getResourceStorages().getResourceDocStream(Cef.EXTENSION_RESOURCE_ROOT.buildChild("private/" + name + ".txt"));
        if (docStream == null) {
            return null;
        }
        BufferedReader bufr = new BufferedReader(new InputStreamReader(docStream.getInputStream(), "UTF-8"));
        try {
            TableDef tableDef2;
            TableExportContext tableExportContext = this.bdfServer.getTableExportContext();
            tableDef = tableDef2 = TableDefParser.parse((Reader)bufr, (Subset)corpus, (TableExportContext)tableExportContext, (LineMessageHandler)LogUtils.NULL_LINEMESSAGEHANDLER, (int)0);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bufr.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                throw new NestedIOException(ioe);
            }
        }
        bufr.close();
        return tableDef;
    }

    private List<String> getLogistiqueList() {
        ArrayList<String> list = new ArrayList<String>();
        RelativePath privatePath = Cef.EXTENSION_RESOURCE_ROOT.buildChild("private");
        SortedMap map = this.bdfServer.getResourceStorages().listResources(privatePath, false);
        for (String name : map.keySet()) {
            if (!name.startsWith("logistique-") || !name.endsWith(".txt")) continue;
            name = name.substring("logistique-".length(), name.length() - 4);
            list.add(name);
        }
        return list;
    }

    private InstructionResolver doAction(String actionString) {
        if (actionString.equals("participants")) {
            ParticipantsAction action = new ParticipantsAction(this.bdfServer);
            action.doAction();
            return action.getResultValueResolver();
        }
        return null;
    }
}

