/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.bdis.pages;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.ficheform.FicheFormParameters;
import fr.exemole.bdfserver.api.ficheform.FormElement;
import fr.exemole.bdfserver.api.ficheform.FormElementProvider;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.ui.FieldUi;
import fr.exemole.bdfserver.api.ui.IncludeUi;
import fr.exemole.bdfserver.api.ui.UiComponents;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.html.forms.FormHandler;
import fr.exemole.bdfserver.tools.exportation.transformation.BdfTransformationUtils;
import fr.exemole.bdfserver.tools.ficheform.FicheFormParametersBuilder;
import fr.exemole.bdfserver.tools.ficheform.FormElementProviderFactory;
import fr.exemole.bdfserver.tools.ui.components.IncludeUiBuilder;
import fr.exemole.bdfserver.tools.users.BdfUserUtils;
import java.util.Properties;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.namespaces.BdfSpace;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.utils.FichothequeUtils;
import net.fichotheque.utils.pointeurs.PointeurFactory;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.instruction.Argument;
import net.mapeadores.util.instruction.Instruction;
import net.mapeadores.util.instruction.InstructionResolver;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.text.StringUtils;

public class SaisieGabaritResolver
implements InstructionResolver {
    private static final String PARTIE_PREFIX = "PARTIE_";
    private static final String PROP_PREFIX = "PROP_";
    private final BdfUser bdfUser;
    private final BdfParameters bdfParameters;
    private final Properties properties;
    private final FormElementProvider formElementProvider;
    private final BdfServer bdfServer;
    private final UiComponents uiComponents;
    private final FicheMeta ficheMeta;
    private final FichePointeur fichePointeur;

    public SaisieGabaritResolver(BdfParameters bdfParameters, Corpus corpus, Properties properties, FicheMeta ficheMeta) {
        this.properties = properties;
        this.bdfUser = bdfParameters.getBdfUser();
        this.bdfParameters = bdfParameters;
        this.fichePointeur = PointeurFactory.newFichePointeur((Corpus)corpus);
        this.formElementProvider = FormElementProviderFactory.newInstance((FicheFormParameters)FicheFormParametersBuilder.build((BdfParameters)bdfParameters).toFicheFormParameters());
        this.bdfServer = bdfParameters.getBdfServer();
        this.uiComponents = this.bdfServer.getUiManager().getMainUiComponents(corpus);
        this.ficheMeta = ficheMeta;
    }

    public Object resolve(Instruction instruction) throws ErrorMessageException {
        String name = ((Argument)instruction.get(0)).getKey();
        if (name.equals("RSCPATH")) {
            return "http://bdis.exemole.fr/saisie-bdis/";
        }
        if (name.startsWith(PARTIE_PREFIX)) {
            String key = name.substring(PARTIE_PREFIX.length());
            String value = this.properties.getProperty(key);
            if (value == null) {
                return null;
            }
            String[] tokens = StringUtils.getTechnicalTokens((String)value, (boolean)true);
            StringBuilder stringBuilder = new StringBuilder();
            HtmlPrinter htmlPrinter = this.getHtmlPrinter(stringBuilder);
            for (String token : tokens) {
                IncludeKey includeKey;
                IncludeUi includeUi;
                Object obj = FichothequeUtils.parseKey((String)token);
                FormElement.Field formElement = null;
                if (obj instanceof FieldKey) {
                    FieldUi fieldUi = (FieldUi)this.uiComponents.getUiComponent(obj);
                    if (fieldUi != null) {
                        formElement = this.formElementProvider.getFormElement(this.fichePointeur, fieldUi);
                    }
                } else if (obj instanceof IncludeKey && (includeUi = (IncludeUi)this.uiComponents.getUiComponent((Object)(includeKey = (IncludeKey)obj))) != null) {
                    SubsetKey subsetKey = includeKey.getSubsetKey();
                    if (subsetKey.isThesaurusSubset()) {
                        IncludeUiBuilder includeUiBuilder = IncludeUiBuilder.init((IncludeUi)includeUi);
                        includeUiBuilder.getAttributeChangeBuilder().appendValue(BdfSpace.IDALPHASTYLE_KEY, "ignore");
                        includeUi = includeUiBuilder.toIncludeUi();
                    }
                    formElement = this.formElementProvider.getFormElement(this.fichePointeur, includeUi);
                }
                if (formElement == null) continue;
                FormHandler.build((BdfParameters)this.bdfParameters).printFormElement(htmlPrinter, formElement);
            }
            return stringBuilder.toString();
        }
        if (name.startsWith(PROP_PREFIX)) {
            String propKey = name.substring(PROP_PREFIX.length());
            String propValue = this.properties.getProperty(propKey);
            if (propValue != null) {
                return propValue;
            }
            return "!!! unknown property: " + propKey;
        }
        if (name.equals("FICHE")) {
            if (this.ficheMeta == null) {
                return "!!! FicheMeta nul !!!";
            }
            String ficheString = this.getFicheString();
            int idx1 = ficheString.indexOf("<body>");
            int idx2 = ficheString.indexOf("</body>");
            return ficheString.substring(idx1 + "<body>".length(), idx2);
        }
        return null;
    }

    private HtmlPrinter getHtmlPrinter(StringBuilder stringBuilder) {
        HtmlPrinter htmlPrinter = new HtmlPrinter();
        htmlPrinter.addMessageLocalisation(this.bdfParameters.getMessageLocalisation());
        htmlPrinter.initPrinter((Appendable)stringBuilder);
        return htmlPrinter;
    }

    public String getFicheString() {
        String simpleTemplateName = this.properties.getProperty("xslt");
        BdfParameters firstAdminBdfParameters = BdfUserUtils.getFirstAdminBdfParameters((BdfServer)this.bdfServer);
        return BdfTransformationUtils.getFicheString((BdfParameters)firstAdminBdfParameters, (String)simpleTemplateName, (FicheMeta)this.ficheMeta, (Lang)this.bdfUser.getWorkingLang(), (String)"../../");
    }
}

