/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.bdis;

import fr.exemole.bdfext.bdis.Bdis;
import fr.exemole.bdfext.bdis.pages.SaisieGabaritResolver;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.instruction.BdfInstruction;
import fr.exemole.bdfserver.api.instruction.BdfInstructionConstants;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.email.tools.FicheSendTools;
import fr.exemole.bdfserver.tools.EditionTools;
import fr.exemole.bdfserver.tools.docstream.DocStreamFactory;
import fr.exemole.bdfserver.tools.users.BdfUserUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.fichotheque.Fichotheque;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.utils.SphereUtils;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.attr.CheckedNameSpace;
import net.mapeadores.util.exceptions.NestedIOException;
import net.mapeadores.util.html.GabaritHtmlProducer;
import net.mapeadores.util.html.HtmlProducer;
import net.mapeadores.util.instruction.InstructionResolver;
import net.mapeadores.util.io.DocStream;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.request.AppendableRequestMap;
import net.mapeadores.util.request.RequestConf;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.request.RequestUtils;
import net.mapeadores.util.servlets.ResponseHandler;
import net.mapeadores.util.servlets.handlers.HtmlResponseHandler;
import net.mapeadores.util.servlets.handlers.SimpleResponseHandler;
import net.mapeadores.util.xml.DOMUtils;
import org.w3c.dom.Document;

public class BdisBdfInstruction
implements BdfInstruction,
BdfInstructionConstants {
    private static final SubsetKey corpusKey = SubsetKey.build((String)"corpus_structure");
    private static final FieldKey courrielKey = FieldKey.build((String)"info_courrielstransmission");
    private static final AttributeKey expediteurAttributeKey = AttributeKey.build((CheckedNameSpace)CheckedNameSpace.build((CharSequence)"CONFIRM"), (CharSequence)"idexpediteur");
    private final BdfServer bdfServer;
    private final RequestMap requestMap;
    private final Map<String, String> instructionMap;

    public BdisBdfInstruction(BdfServer bdfServer, RequestMap requestMap, Map<String, String> instructionMap) {
        this.bdfServer = bdfServer;
        this.requestMap = requestMap;
        this.instructionMap = instructionMap;
    }

    public short getBdfUserNeed() {
        return 1;
    }

    public ResponseHandler runInstruction(BdfUser bdfUser) {
        String page = this.instructionMap.get("page");
        String type = this.instructionMap.get("type");
        Properties properties = this.getProperties(page, type);
        FicheMeta ficheMeta = null;
        BdfParameters firstAdminBdfParameters = BdfUserUtils.getFirstAdminBdfParameters((BdfServer)this.bdfServer);
        if (page.equals("resultat")) {
            RequestConf requestConf = this.getRequestConf(page, type);
            AppendableRequestMap mergedRequestMap = RequestUtils.merge((RequestMap)this.requestMap, (List)requestConf.getSupplementaryParameterList());
            try (EditSession editSession = this.bdfServer.initEditSession("ext:Bdis");){
                ficheMeta = EditionTools.createFiche((EditSession)editSession, (BdfParameters)firstAdminBdfParameters, (SubsetKey)corpusKey, (RequestMap)mergedRequestMap);
            }
            this.envoi(ficheMeta, requestConf, type);
        }
        return this.getResponseHandler(page, type, properties, firstAdminBdfParameters, ficheMeta);
    }

    private ResponseHandler getResponseHandler(String page, String type, Properties properties, BdfParameters bdfParameters, FicheMeta ficheMeta) {
        try {
            String gabaritString = this.getGabarit(page, type);
            if (gabaritString == null) {
                return SimpleResponseHandler.init((String)("Ressource introuvable : saisie-" + type + ".html"));
            }
            Corpus corpus = (Corpus)this.bdfServer.getFichotheque().getSubset(corpusKey);
            SaisieGabaritResolver saisieGabaritResolver = new SaisieGabaritResolver(bdfParameters, corpus, properties, ficheMeta);
            return HtmlResponseHandler.init((HtmlProducer)new GabaritHtmlProducer(gabaritString, (InstructionResolver)saisieGabaritResolver));
        }
        catch (IOException ioe) {
            return SimpleResponseHandler.init((String)("IOException : " + ioe.getMessage()));
        }
    }

    private String getGabarit(String page, String type) throws IOException {
        DocStream docStream = this.getExtensionDocStream("private/" + page + "-" + type + ".html");
        if (docStream == null) {
            return null;
        }
        try (InputStream is = docStream.getInputStream();){
            String string = IOUtils.toString((InputStream)is, (String)"UTF-8");
            return string;
        }
    }

    private Properties getProperties(String page, String type) {
        Properties properties = new Properties();
        DocStream docStream = this.getExtensionDocStream("private/" + type + ".properties");
        if (docStream == null) {
            return properties;
        }
        try (InputStream is = docStream.getInputStream();){
            properties.load(is);
        }
        catch (IOException ioe) {
            throw new NestedIOException(ioe);
        }
        return properties;
    }

    private RequestConf getRequestConf(String page, String type) {
        URI uri = URI.create("bdf://this/xml/" + page + "-" + type + ".xml");
        DocStream docStream = DocStreamFactory.buildDocStream((BdfServer)this.bdfServer, (URI)uri);
        Document document = null;
        if (docStream != null) {
            document = DOMUtils.readDocument((DocStream)docStream);
        }
        if (document == null) {
            return RequestUtils.EMPTY_REQUESTCONF;
        }
        return RequestUtils.parseRequestConf((Document)document);
    }

    private void envoi(FicheMeta ficheMeta, RequestConf requestConf, String type) {
        String sujet = this.getText("courriel_sujet", type);
        String texte = this.getText("courriel_texte", type);
        Attribute attribute = requestConf.getAttributes().getAttribute(expediteurAttributeKey);
        if (attribute == null) {
            System.out.println("Missing: " + expediteurAttributeKey.toString());
            return;
        }
        BdfUser expediteur = null;
        try {
            Redacteur redacteur = SphereUtils.parse((Fichotheque)this.bdfServer.getFichotheque(), (String)attribute.getFirstValue());
            expediteur = this.bdfServer.createBdfUser(redacteur);
        }
        catch (SphereUtils.RedacteurLoginException rle) {
            throw new IllegalArgumentException(rle);
        }
        FicheSendTools.sendFiche((BdfServer)this.bdfServer, (BdfUser)expediteur, (FicheMeta)ficheMeta, (FieldKey)courrielKey, (String)sujet, (String)texte);
    }

    private String getText(String fichier, String type) {
        String string;
        block9: {
            DocStream docStream = this.getExtensionDocStream("private/" + fichier + "-" + type + ".txt");
            if (docStream == null) {
                return fichier + "-" + type + ".txt inconnu";
            }
            InputStream is = docStream.getInputStream();
            try {
                string = IOUtils.toString((InputStream)is, (String)"UTF-8");
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    throw new NestedIOException(ioe);
                }
            }
            is.close();
        }
        return string;
    }

    private DocStream getExtensionDocStream(String path) {
        return this.bdfServer.getResourceStorages().getResourceDocStream(Bdis.EXTENSION_RESOURCE_ROOT.buildChild(path));
    }
}

