/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.arga.pages;

import fr.exemole.bdfext.arga.JagaLocalisation;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.ficheform.FicheFormParameters;
import fr.exemole.bdfserver.api.ficheform.FormElement;
import fr.exemole.bdfserver.api.ficheform.FormElementProvider;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.ui.FieldUi;
import fr.exemole.bdfserver.api.ui.IncludeUi;
import fr.exemole.bdfserver.api.ui.UiComponent;
import fr.exemole.bdfserver.api.ui.UiComponents;
import fr.exemole.bdfserver.html.forms.FormHandler;
import fr.exemole.bdfserver.html.forms.FormParameters;
import fr.exemole.bdfserver.tools.exportation.transformation.BdfTransformationUtils;
import fr.exemole.bdfserver.tools.ficheform.FicheFormParametersBuilder;
import fr.exemole.bdfserver.tools.ficheform.FormElementProviderFactory;
import fr.exemole.bdfserver.tools.users.BdfUserUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.croisement.Croisements;
import net.fichotheque.croisement.Liaison;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.CroisementUtils;
import net.fichotheque.utils.pointeurs.PointeurFactory;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.instruction.Argument;
import net.mapeadores.util.instruction.Instruction;
import net.mapeadores.util.instruction.InstructionResolver;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.localisation.UserLangContext;
import net.mapeadores.util.logging.ErrorMessageException;

public class JagaGabaritResolver
implements InstructionResolver {
    private static final SubsetKey conferenceThesaurusKey = SubsetKey.build((short)2, (String)"jagaconference");
    private static final SubsetKey atelierThesaurusKey = SubsetKey.build((short)2, (String)"jagaatelier");
    private static final SubsetKey atelierCorpusKey = SubsetKey.build((short)1, (String)"jagaatelier");
    private final BdfServer bdfServer;
    private final MessageLocalisation jagaMessageLocalisation;
    private final HtmlPrinter htmlPrinter;
    private final FormElementProvider formElementProvider;
    private final UiComponents uiComponents;
    private final FicheMeta ficheMeta;
    private final JagaLocalisation jagaLocalisation;
    private final Thesaurus conferenceThesaurus;
    private final Thesaurus atelierThesaurus;
    private final Corpus atelierCorpus;
    private final FichePointeur fichePointeur;
    private Motcle atelierMotcle;
    private final Map<String, String> confMap = new HashMap<String, String>();

    public JagaGabaritResolver(BdfParameters bdfParameters, JagaLocalisation jagaLocalisation, Corpus corpus, FicheMeta ficheMeta, Map<String, String> instructionMap) {
        this.bdfServer = bdfParameters.getBdfServer();
        this.ficheMeta = ficheMeta;
        this.jagaLocalisation = jagaLocalisation;
        this.jagaMessageLocalisation = jagaLocalisation.getMessageLocalisation();
        this.fichePointeur = PointeurFactory.newFichePointeur((Corpus)corpus);
        this.formElementProvider = FormElementProviderFactory.newInstance((FicheFormParameters)FicheFormParametersBuilder.build((BdfParameters)bdfParameters).setUserLangContext((UserLangContext)jagaLocalisation).toFicheFormParameters());
        this.htmlPrinter = new HtmlPrinter();
        this.htmlPrinter.addMessageLocalisation(this.bdfServer.getL10nManager().getMessageLocalisation((UserLangContext)jagaLocalisation));
        this.uiComponents = this.bdfServer.getUiManager().getMainUiComponents(corpus);
        Fichotheque fichotheque = this.bdfServer.getFichotheque();
        this.conferenceThesaurus = (Thesaurus)fichotheque.getSubset(conferenceThesaurusKey);
        this.atelierThesaurus = (Thesaurus)fichotheque.getSubset(atelierThesaurusKey);
        this.atelierCorpus = (Corpus)fichotheque.getSubset(atelierCorpusKey);
        String atelierString = instructionMap.get("atelier");
        if (atelierString != null) {
            int idatelier = Integer.parseInt(atelierString);
            this.atelierMotcle = this.atelierThesaurus.getMotcleById(idatelier);
        }
    }

    public Object resolve(Instruction instruction) throws ErrorMessageException {
        String name = ((Argument)instruction.get(0)).getKey();
        if (name.equals("CONF")) {
            int argumentSize = instruction.size();
            if (argumentSize == 1) {
                return "#CONF PARAM NAME IS MISSING#";
            }
            if (argumentSize == 2) {
                return "#CONF PARAM VALUE IS MISSING: " + ((Argument)instruction.get(1)).getKey() + "#";
            }
            this.confMap.put(((Argument)instruction.get(1)).getKey(), ((Argument)instruction.get(2)).getKey());
            return "";
        }
        if (name.equals("LANG")) {
            return this.jagaLocalisation.getLang().toString();
        }
        if (name.equals("ATELIER")) {
            if (this.atelierMotcle != null) {
                return "<input type=\"hidden\" name=\"thesaurus_jagaatelier\" value=\"" + this.atelierMotcle.getIdalpha() + "\">" + this.atelierMotcle.getLabelString(this.jagaLocalisation.getLang());
            }
            return this.getAtelierSelect();
        }
        if (name.equals("LIB")) {
            int argumentSize = instruction.size();
            if (argumentSize == 1) {
                return "#LIB KEY IS MISSING#";
            }
            return this.jagaMessageLocalisation.toString(((Argument)instruction.get(1)).getKey());
        }
        if (name.equals("CHAMP")) {
            int argumentCount = instruction.size();
            if (argumentCount == 1) {
                return "#CHAMP KEY IS MISSING#";
            }
            String componentName = ((Argument)instruction.get(1)).getKey();
            UiComponent componentUI = this.uiComponents.getUiComponent(componentName);
            if (componentUI == null) {
                return "#UNKNOWN KEY: " + componentName + "#";
            }
            StringBuilder stringBuilder = new StringBuilder();
            this.htmlPrinter.initPrinter((Appendable)stringBuilder);
            FormElement.Field formElement = null;
            if (componentUI instanceof FieldUi) {
                formElement = this.formElementProvider.getFormElement(this.fichePointeur, (FieldUi)componentUI);
            } else if (componentUI instanceof IncludeUi) {
                formElement = this.formElementProvider.getFormElement(this.fichePointeur, (IncludeUi)componentUI);
            }
            if (formElement != null) {
                FormHandler.init((FormParameters)FormParameters.init((BdfServer)this.bdfServer, (UserLangContext)this.jagaLocalisation)).printFormElement(this.htmlPrinter, (FormElement)formElement);
            }
            this.htmlPrinter.flush();
            return stringBuilder.toString();
        }
        if (name.equals("FICHE")) {
            if (this.ficheMeta == null) {
                return "!!! FicheMeta nul !!!";
            }
            String ficheString = this.getFicheString();
            int idx1 = ficheString.indexOf("<body>");
            int idx2 = ficheString.indexOf("</body>");
            return ficheString.substring(idx1 + "<body>".length(), idx2);
        }
        if (name.equals("PAGE")) {
            int argumentCount = instruction.size();
            if (argumentCount == 1) {
                return "#PAGE ID IS MISSING#";
            }
            try {
                int ficheid = Integer.parseInt(((Argument)instruction.get(1)).getKey());
                if (ficheid < 1) {
                    return "#PAGE ID MUST BE POSITIVE: " + ficheid + "#";
                }
                String text = this.jagaLocalisation.getFicheText(ficheid);
                if (text == null) {
                    return "#UNKNOWN PAGE ID: " + ficheid + "#";
                }
                return text;
            }
            catch (NumberFormatException nfe) {
                return "#PAGE ID MUST BE A NUMBER: " + ((Argument)instruction.get(1)).getKey() + "#";
            }
        }
        return "#UNABLE TO RESOLVE INCLUSION: $" + name + "$#";
    }

    public String getFicheString() {
        String simpleTemplateName = null;
        String val = this.confMap.get("template");
        if (val != null) {
            simpleTemplateName = val;
        }
        BdfParameters firstAdminBdfParameters = BdfUserUtils.getFirstAdminBdfParameters((BdfServer)this.bdfServer);
        return BdfTransformationUtils.getFicheString((BdfParameters)firstAdminBdfParameters, (String)simpleTemplateName, (FicheMeta)this.ficheMeta, (Lang)this.jagaLocalisation.getLang(), (String)"../../");
    }

    private String getAtelierSelect() {
        Fichotheque fichotheque = this.conferenceThesaurus.getFichotheque();
        Lang lang = this.jagaLocalisation.getLang();
        StringBuilder buf = new StringBuilder();
        buf.append("<select  name=\"thesaurus_jagaatelier\">");
        for (Motcle motcle : this.conferenceThesaurus.getFirstLevelList()) {
            Croisements ficheCroisements = fichotheque.getCroisements((SubsetItem)motcle, (Subset)this.atelierCorpus);
            if (ficheCroisements.isEmpty()) continue;
            buf.append("<optgroup label=\"");
            buf.append(motcle.getLabelString(lang));
            buf.append("\">");
            Collection liaisons = CroisementUtils.sortByWeight((Croisements)ficheCroisements, (String)"");
            for (Liaison liaison : liaisons) {
                FicheMeta atelierFicheMeta = (FicheMeta)liaison.getSubsetItem();
                Motcle atelier = this.atelierThesaurus.getMotcleById(atelierFicheMeta.getId());
                buf.append("<option value=\"");
                buf.append(atelier.getIdalpha());
                buf.append("\">");
                buf.append(atelier.getLabelString(lang));
                buf.append("</option>");
            }
            buf.append("</optgroup>");
        }
        buf.append("</select>");
        return buf.toString();
    }
}

