/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.annuaire.commands;

import fr.exemole.bdfext.annuaire.commands.KeyArrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.metadata.FieldKey;
import net.mapeadores.util.text.StringUtils;

public class FieldKeyMap {
    private Map<String, KeyArrays> arrayMap = new HashMap<String, KeyArrays>();

    public FieldKeyMap() {
        this.initFieldKey("nomprenom", "prop_personne");
        this.initFieldKey("organisme", "prop_orgasigle,prop_orgadeveloppe");
        this.initFieldKey("localisation", "prop_pays,prop_ville");
        this.initThesaurusKey("localisation", "thesaurus_geo, thesaurus_continent");
        this.initThesaurusKey("nomenclature", "thesaurus_nomenclature,thesaurus_reseau, thesaurus_sousreseau");
        this.initThesaurusKey("motscles", "thesaurus_dph,thesaurus_act,thesaurus_mtd,thesaurus_theme,thesaurus_nomenclature,thesaurus_geo,thesaurus_continent");
    }

    public KeyArrays getKeyArrays(String name) {
        return this.arrayMap.get(name);
    }

    private void initFieldKey(String name, String champs) {
        String[] tokens = StringUtils.getTechnicalTokens((String)champs, (boolean)true);
        int length = tokens.length;
        ArrayList<FieldKey> fieldKeyList = new ArrayList<FieldKey>();
        for (int i = 0; i < length; ++i) {
            fieldKeyList.add(FieldKey.build((String)tokens[i]));
        }
        KeyArrays keyArrays = this.getOrCreateKeyArrays(name);
        keyArrays.setFieldKeyList(fieldKeyList);
    }

    private void initThesaurusKey(String name, String champs) {
        String[] tokens = StringUtils.getTechnicalTokens((String)champs, (boolean)true);
        int length = tokens.length;
        SubsetKey[] thesaurusKeyArray = new SubsetKey[length];
        for (int i = 0; i < length; ++i) {
            thesaurusKeyArray[i] = SubsetKey.build((String)tokens[i]);
        }
        KeyArrays keyArrays = this.getOrCreateKeyArrays(name);
        keyArrays.setThesaurusKeyArray(thesaurusKeyArray);
    }

    private KeyArrays getOrCreateKeyArrays(String name) {
        KeyArrays keyArrays = this.arrayMap.get(name);
        if (keyArrays == null) {
            keyArrays = new KeyArrays();
            this.arrayMap.put(name, keyArrays);
        }
        return keyArrays;
    }
}

