/* FichothequeLib_Tools - Copyright (c) 2016-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque.tools.format.formatters;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.instruction.Argument;
import net.mapeadores.util.instruction.Instruction;
import net.mapeadores.util.json.PropertyEligibility;
import net.mapeadores.util.text.StringUtils;


/**
 *
 * @author Vincent Calame
 */
public class JsonParameters implements PropertyEligibility {

    private final static String PROPERTIES_PREFIX = "properties=";
    private final Set<String> propertyNameSet;
    private final String cellConverterName;

    public JsonParameters(Set<String> propertyNameSet, String cellConverterName) {
        this.propertyNameSet = propertyNameSet;
        this.cellConverterName = cellConverterName;
    }

    @Override
    public boolean includeProperty(String propertyName) {
        if (propertyName.equals("properties")) {
            return (cellConverterName != null);
        }
        return propertyNameSet.contains(propertyName);
    }

    @Nullable
    public String getCellConverterName() {
        return cellConverterName;
    }

    /**
     * Peut être nul.
     *
     * @param instruction
     * @return instance de JsonParameters ou null
     */
    public static JsonParameters fromInstruction(Instruction instruction) {
        Set<String> propertyNameSet = new HashSet<String>();
        boolean here = false;
        String cellConverterName = null;
        for (Argument argument : instruction) {
            String key = argument.getKey();
            String value = argument.getValue();
            switch (key) {
                case "include": {
                    here = true;
                    if (value != null) {
                        String[] tokens = StringUtils.getTechnicalTokens(value, true);
                        propertyNameSet.addAll(Arrays.asList(tokens));
                    }
                    break;
                }
                case "properties":
                case "cells": {
                    if (value != null) {
                        cellConverterName = value;
                        here = true;
                    }
                    break;
                }

            }
        }
        if (!here) {
            return null;
        }
        return new JsonParameters(propertyNameSet, cellConverterName);
    }

    public static JsonParameters parse(String propertyNames) {
        Set<String> propertyNameSet = new HashSet<String>();
        String[] tokens = StringUtils.getTechnicalTokens(propertyNames, true);
        String cellConverterName = null;
        for (String token : tokens) {
            if (token.startsWith(PROPERTIES_PREFIX)) {
                cellConverterName = token.substring(PROPERTIES_PREFIX.length()).trim();
                if (cellConverterName.length() == 0) {
                    cellConverterName = null;
                }
            } else {
                propertyNameSet.add(token);
            }
        }
        propertyNameSet.addAll(Arrays.asList(tokens));
        return new JsonParameters(propertyNameSet, cellConverterName);
    }

}
