/* FichothequeLib_Tools - Copyright (c) 2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque.tools.extraction.syntaxes;


/**
 *
 * @author Vincent Calame
 */
public class UicomponentResolver extends AbstractStepResolver {

    private final static String MASTER_PREFIX = "_master_";
    private final static short SUBSET_FAMILY = 1;
    private final static short COMMENT_FAMILY = 2;
    private final static short FIELD_FAMILY = 3;
    private final static short UNIQUE_FAMILY = 4;
    private short family;
    private int tokenPosition = 1;

    private UicomponentResolver() {

    }

    @Override
    public void resolveChar(char carac) {
        switch (carac) {
            case '_':
                resolveSeparator();
                break;
            default:
                appendChar(carac);
        }
    }

    @Override
    public String getStepClassName(String textPart, boolean lastPart) {
        if (tokenPosition == 1) {
            switch (textPart) {
                case "corpus":
                case "thesaurus":
                case "album":
                case "addenda":
                    family = SUBSET_FAMILY;
                    return "cm-component-subset";
                case "liage":
                case "parentage":
                    family = UNIQUE_FAMILY;
                    return "cm-component-subset";
                case "comment":
                    family = COMMENT_FAMILY;
                    return "cm-component-comment";
                case "title":
                case "subtitle":
                case "owners":
                case "lang":
                case "titre":
                case "soustitre":
                case "redacteurs":
                    family = UNIQUE_FAMILY;
                    return "cm-component-field";
                default:
                    family = FIELD_FAMILY;
                    return "cm-component-field";
            }
        } else {
            switch (family) {
                case SUBSET_FAMILY: {
                    if (tokenPosition == 2) {
                        return "cm-quote";
                    } else if (tokenPosition < 5) {
                        if ((textPart.length() > 1)) {
                            try {
                                int weight = Integer.parseInt(textPart.substring(1));
                                return "cm-number";
                            } catch (NumberFormatException nfe) {

                            }
                        }
                        return "cm-def";
                    } else {
                        return "cm-error";
                    }
                }
                case COMMENT_FAMILY: {
                    if (tokenPosition == 2) {
                        return "cm-quote";
                    } else {
                        return "cm-error";
                    }
                }
                case UNIQUE_FAMILY: {
                    return "cm-error";
                }
                case FIELD_FAMILY: {
                    if (tokenPosition == 2) {
                        return "cm-quote";
                    } else if (tokenPosition == 3) {
                        return "cm-string";
                    } else if (tokenPosition == 4) {
                        return "cm-string-2";
                    } else {
                        return "cm-error";
                    }
                }
                default:
                    return "cm-error";
            }
        }
    }

    private void resolveSeparator() {
        flush();
        tokenPosition++;
        appendToCurrent('_');
    }

    private void appendChar(char carac) {
        appendToCurrent(carac);
    }

    public static String resolve(String value) {
        if (value.isEmpty()) {
            return "";
        }
        UicomponentResolver resolver = new UicomponentResolver();
        if (value.startsWith(MASTER_PREFIX)) {
            resolver.appendToFinal("cm-qualifier", MASTER_PREFIX);
            value = value.substring(MASTER_PREFIX.length());
        }
        resolver.resolveText(value);
        return resolver.end();
    }

}
