/* FichothequeLib_API - Copyright (c) 2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque.corpus.metadata;

import net.mapeadores.util.money.ExtendedCurrency;


/**
 *
 * @author Vincent Calame
 */
public class AmountSubfieldKey extends SubfieldKey {

    private final ExtendedCurrency currency;

    public AmountSubfieldKey(FieldKey fieldKey, ExtendedCurrency currency) {
        super(fieldKey, SubfieldKey.AMOUNT_SUBTYPE);
        this.currency = currency;
    }

    public ExtendedCurrency getCurrency() {
        return currency;
    }

    @Override
    public int hashCode() {
        return fieldKey.hashCode() + currency.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        AmountSubfieldKey fk = (AmountSubfieldKey) other;
        if (!fk.fieldKey.equals(this.fieldKey)) {
            return false;
        }
        return fk.currency.equals(this.currency);
    }

    @Override
    public String toString() {
        return fieldKey.getKeyString() + "_" + SubfieldKey.AMOUNT_SUBTYPE + "_" + currency.toString();
    }

}
