/* FichothequeLib_API - Copyright (c) 2008-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque.corpus.fiche;

import java.io.Serializable;
import net.mapeadores.util.primitives.DegreDecimal;


/**
 *
 * @author Vincent Calame
 */
public final class GeopointItem implements FicheItem, Serializable {

    private static final long serialVersionUID = 3L;
    private DegreDecimal latitude;
    private DegreDecimal longitude;

    public GeopointItem(DegreDecimal latitude, DegreDecimal longitude) {
        if (latitude == null) {
            throw new IllegalArgumentException("latitude is null");
        }
        if (longitude == null) {
            throw new IllegalArgumentException("longitude is null");
        }
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public DegreDecimal getLatitude() {
        return latitude;
    }

    public DegreDecimal getLongitude() {
        return longitude;
    }

}
