/* BdfServer_Multi - Copyright (c) 2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package fr.exemole.bdfserver.multi.subscribe;

import fr.exemole.bdfserver.html.consumers.Button;
import fr.exemole.bdfserver.html.consumers.Grid;
import fr.exemole.bdfserver.html.consumers.PageUnit;
import fr.exemole.bdfserver.html.consumers.attributes.InputPattern;
import fr.exemole.bdfserver.html.jslib.BdfJsLibs;
import fr.exemole.bdfserver.multi.api.Multi;
import fr.exemole.bdfserver.multi.htmlproducers.MultiHtmlProducer;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.request.RequestConstants;


/**
 *
 * @author Vincent Calame
 */
public class FichothequeFormHtmlProducer extends MultiHtmlProducer {

    private final SubscribeToken subscribeToken;

    public FichothequeFormHtmlProducer(Multi multi, SubscribeToken subscribeToken) {
        super(multi);
        this.subscribeToken = subscribeToken;
        addJsLib(BdfJsLibs.COMMANDTEST);
        addThemeCss("multisubscribe.css");
    }

    @Override
    public void printHtml() {
        startLoc("_ title.multi.subcribe");
        this
                .MAIN("multisubscribe-Main")
                .__(PageUnit.start("action-Subscribe", "_ title.multi.subcribe"))
                .__(printCommandMessage())
                .__(printForm())
                .__(PageUnit.END)
                ._MAIN();
        end();
    }

    private boolean printForm() {
        this
                .FORM_post(HA.action("multi-subscribe").attr("data-submit-process", "test"))
                .INPUT_hidden(RequestConstants.COMMAND_PARAMETER, FichothequeSubscribeCommand.COMMAND_NAME)
                .INPUT_hidden(SubscribeCommand.TOKEN_PARAMNAME, subscribeToken.getToken())
                .__(Grid.START)
                .__(Grid.textInputRow("_ label.subscribe.fichothequename", name(FichothequeSubscribeCommand.NEWFICHOTHEQUE_PARAMNAME).populate(InputPattern.TECHNICAl_UNDERSCORE).size("15")))
                .__(Grid.textInputRow("_ label.subscribe.sphere", name(FichothequeSubscribeCommand.FIRSTSPHERE_PARAMNAME).populate(InputPattern.TECHNICAL_STRICT).size("15").value("admin")))
                .__(Grid.textInputRow("_ label.subscribe.login", name(FichothequeSubscribeCommand.FIRSTUSER_PARAMNAME).populate(InputPattern.LOGIN).size("15")))
                .__(Grid.passwordInputRow("_ label.subscribe.firstpassword_1", name(FichothequeSubscribeCommand.FIRSTPASSWORD1_PARAMNAME).size("15")))
                .__(Grid.passwordInputRow("_ label.subscribe.firstpassword_2", name(FichothequeSubscribeCommand.FIRSTPASSWORD2_PARAMNAME).size("15")))
                .__(Grid.END)
                .__(Button.COMMAND,
                        Button.submit("action-Subscribe", "_ submit.subscribe.createfichotheque"))
                ._FORM();
        return true;
    }

}
