/* BdfServer_HtmlProducers - Copyright (c) 2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package fr.exemole.bdfserver.htmlproducers.edition;

import fr.exemole.bdfserver.api.interaction.Domains;
import fr.exemole.bdfserver.api.interaction.InteractionConstants;
import fr.exemole.bdfserver.api.interaction.domains.EditionDomain;
import fr.exemole.bdfserver.api.interaction.domains.MainDomain;
import fr.exemole.bdfserver.html.BdfHtmlConstants;
import fr.exemole.bdfserver.html.consumers.Button;
import fr.exemole.bdfserver.tools.BH;
import fr.exemole.bdfserver.tools.instruction.BdfInstructionUtils;
import fr.exemole.bdfserver.tools.instruction.RequestHandler;
import net.fichotheque.corpus.FicheMeta;
import net.mapeadores.util.html.JsObject;


/**
 *
 * @author Vincent Calame
 */
public class FicheResultHandler {

    public final static Button REFRESH_BUTTON = Button.link(BH.domain(Domains.MAIN).page(MainDomain.FICHES_PAGE).param(MainDomain.FICHES_RELOAD_PARAMNAME, "1").toString()).target(BdfHtmlConstants.LIST_FRAME).action("action-Refresh").textL10nObject("_ link.global.refresh").tooltipMessage("_ link.main.fiches_update");
    public final static Button OVERLAY_CLOSE_BUTTON = Button.button().style(Button.LINK_STYLE).textL10nObject("_ link.global.close").action("action-Close").buttonId("button_overlay_close").shortcutKey("Escape").shortcutTooltip("Esc");
    public final static int DEFAULT_TYPE = 1;
    public final static int STANDALONE_TYPE = 2;
    public final static int OVERLAY_TYPE = 3;
    private final FicheMeta ficheMeta;
    private final String options;
    private final String gotoValue;

    public FicheResultHandler(FicheMeta ficheMeta, String options, String gotoValue) {
        this.ficheMeta = ficheMeta;
        this.options = options;
        this.gotoValue = gotoValue;
    }

    public FicheMeta getFicheMeta() {
        return ficheMeta;
    }

    public String getOptions() {
        return options;
    }

    public String getGotoValue() {
        return gotoValue;
    }

    public int getToolbarType() {
        if (options == null) {
            return DEFAULT_TYPE;
        }
        if (options.contains("standalone")) {
            return STANDALONE_TYPE;
        }
        if (options.contains("overlay")) {
            return OVERLAY_TYPE;
        }
        return DEFAULT_TYPE;
    }

    public String getFicheLink(String type) {
        return BdfInstructionUtils.getFicheGetLink(ficheMeta, type);
    }

    public String getEditHref() {
        return BH.domain(Domains.EDITION).page(EditionDomain.FICHE_CHANGE_PAGE).subsetItem(ficheMeta).param(InteractionConstants.PAGE_RESULT_OPTIONS_PARAMNAME, options).toString();
    }

    public JsObject getResultItemObject() {
        return JsObject.init()
                .put("type", "fiche")
                .put("corpus", ficheMeta.getCorpus().getSubsetName())
                .put("id", ficheMeta.getId());
    }

    public JsObject getFicheframeArgsObject() {
        return JsObject.init()
                .put("goto", gotoValue)
                .put("pageResultOptions", options);
    }

    public static FicheResultHandler build(FicheMeta ficheMeta, RequestHandler requestHandler) {
        String options = requestHandler.getTrimedParameter(InteractionConstants.PAGE_OPTIONS_PARAMNAME);
        if (options.isEmpty()) {
            options = null;
        }
        return new FicheResultHandler(ficheMeta, options, requestHandler.getTrimedParameter(InteractionConstants.GOTO_PARAMNAME));
    }

}
