/* BdfServer_Html - Copyright (c) 2020-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package fr.exemole.bdfserver.html.consumers;

import net.mapeadores.util.html.HtmlWrapper;
import net.mapeadores.util.html.WrapperFactory;


/**
 *
 * @author Vincent Calame
 */
public final class FicheForm {

    public final static HtmlWrapper STANDARD_CELL = WrapperFactory.div("ficheform-standard-Cell");
    public final static HtmlWrapper MULTIROWS_STANDARD_CELL = WrapperFactory.div("ficheform-standard-Cell ficheform-MultiRows");

    private FicheForm() {

    }

    public static HtmlWrapper getMatchingCellHtmlWrapper(int rows) {
        if (rows < 2) {
            return STANDARD_CELL;
        } else {
            return MULTIROWS_STANDARD_CELL;
        }
    }

}
