/* BdfServer_Commands - Copyright (c) 2011-2024 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package fr.exemole.bdfserver.commands.selection;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.interaction.Domains;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;


/**
 *
 * @author Vincent Calame
 */
public class UserDefaultSelectionCommand extends AbstractBdfCommand {

    public final static String COMMANDNAME = "UserDefaultSelection";

    public UserDefaultSelectionCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        try (EditSession session = startEditSession(Domains.SELECTION, COMMANDNAME)) {
            session.getBdfServerEditor().getBdfUserPrefsEditor(bdfUser.getPrefs()).setDefaultFicheQuery(bdfUser.getFicheQuery());
        }
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {

    }

}
