/* BdfServer - Copyright (c) 2014-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package fr.exemole.bdfserver.json;

import java.io.IOException;
import net.fichotheque.importation.ParseResult;
import net.mapeadores.util.json.CommonJson;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.logging.LineLog;
import net.mapeadores.util.logging.LineLogs;
import net.mapeadores.util.logging.SourceLog;


/**
 *
 * @author Vincent Calame
 */
public final class ImportationJson {

    private ImportationJson() {

    }

    public static void properties(JSONWriter jw, ParseResult parseResult, MessageLocalisation messageLocalisation) throws IOException {
        jw.key("type")
                .value(parseResult.getType());
        jw.key("path")
                .value(parseResult.getPath());
        SourceLog columnLog = parseResult.getColumnLog();
        if (!columnLog.isEmpty()) {
            jw.key("columnLog");
            jw.object();
            CommonJson.properties(jw, columnLog, messageLocalisation);
            jw.endObject();
        }
        LineLogs lineLogs = parseResult.getLineLogs();
        if (!lineLogs.isEmpty()) {
            jw.key("lineLogArray");
            jw.array();
            for (LineLog lineLog : lineLogs) {
                jw.object();
                CommonJson.properties(jw, lineLog, messageLocalisation);
                jw.endObject();
            }
            jw.endArray();
        }
    }

}
