/* BdfServer_API - Copyright (c) 2010-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package fr.exemole.bdfserver.api.instruction;

import java.util.Set;
import net.mapeadores.util.logging.CommandMessage;


/**
 *
 * @author Vincent Calame
 */
public interface BdfCommandResult {

    public Object getResultObject(String name);

    public Set<String> getResultObjectNameSet();

    public CommandMessage getCommandMessage();

    public default boolean isError() {
        CommandMessage commandMessage = getCommandMessage();
        if ((commandMessage != null) && (commandMessage.isErrorMessage())) {
            return true;
        } else {
            return false;
        }
    }

}
