/* BdfServer_API - Copyright (c) 2014-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package fr.exemole.bdfserver.api.configuration;

import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.localisation.ListLangContext;
import net.mapeadores.util.localisation.ListLangContextBuilder;


/**
 *
 * @author Vincent Calame
 */
public interface LangConfiguration {

    /**
     * Doit comprendre au moins un élément.
     */
    public Langs getWorkingLangs();

    public Langs getSupplementaryLangs();

    public boolean isAllLanguages();

    public boolean isWithNonlatin();

    public boolean isWithoutSurnameFirst();

    public default ListLangContext toLangContext() {
        return toLangContext(false);
    }

    public default ListLangContext toLangContext(boolean withSupplementary) {
        ListLangContextBuilder builder = new ListLangContextBuilder();
        builder.addLangs(getWorkingLangs());
        if (withSupplementary) {
            builder.addLangs(getSupplementaryLangs());
        }
        return builder.toListLangContext();
    }

}
