/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.text.tableparser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.mapeadores.util.text.tableparser.CsvParameters;
import net.mapeadores.util.text.tableparser.RowHandler;

public class RowParser {
    private static final int WAITING_FROM_DELIMITER_STEP = 3;
    private static final int WAITING_FROM_VALUE_STEP = 5;
    private static final int VALUE_STEP = 9;
    private static final int QUOTED_VALUE_STEP = 10;
    private final RowHandler rowHandler;
    private final CsvParameters csvParameters;
    private List<String> resultList = new ArrayList<String>();
    private int step = 5;
    private StringBuilder buf = new StringBuilder();
    private boolean previousWhite = false;

    public RowParser(RowHandler rowHandler, CsvParameters csvParameters) {
        this.rowHandler = rowHandler;
        this.csvParameters = csvParameters;
    }

    public void parse(Reader reader) throws IOException {
        String[] array;
        String line;
        boolean lastCompleted = false;
        BufferedReader bufreader = new BufferedReader(reader);
        while ((line = bufreader.readLine()) != null) {
            try {
                boolean complete = this.parseLine(line);
                if (complete) {
                    String[] array2 = this.flushCompleteValues();
                    if (array2 != null) {
                        this.rowHandler.addRow(array2);
                    }
                    lastCompleted = true;
                    continue;
                }
                lastCompleted = false;
            }
            catch (IllegalArgumentException ise) {
                // empty catch block
                break;
            }
        }
        if (!lastCompleted && (array = this.flushCompleteValues()) != null) {
            this.rowHandler.addRow(array);
        }
    }

    private boolean parseLine(String line) {
        int length = line.length();
        for (int i = 0; i < length; ++i) {
            i = this.parseCharAt(line, i);
        }
        if (this.step == 10) {
            this.buf.append('\n');
            return false;
        }
        return true;
    }

    private int parseCharAt(String line, int index) {
        char carac = line.charAt(index);
        if (carac == ' ') {
            switch (this.step) {
                case 3: 
                case 9: {
                    this.previousWhite = true;
                    break;
                }
                case 10: {
                    this.buf.append(carac);
                }
            }
            return index;
        }
        if (carac == this.csvParameters.getDelimiter()) {
            if (this.step != 10) {
                this.flushValue();
                this.step = 5;
            } else {
                this.buf.append(carac);
            }
            return index;
        }
        char quoteChar = this.csvParameters.getQuote();
        boolean escaped = this.csvParameters.isEscapedCSV();
        switch (this.step) {
            case 3: 
            case 5: {
                if (carac == quoteChar) {
                    this.step = 10;
                    break;
                }
                this.step = 9;
                index = this.parseCharAt(carac, line, index, escaped);
                break;
            }
            case 9: {
                if (this.previousWhite) {
                    this.buf.append(' ');
                }
                index = this.parseCharAt(carac, line, index, escaped);
                break;
            }
            case 10: {
                if (carac == quoteChar) {
                    char next;
                    if (!escaped && index < line.length() - 1 && (next = line.charAt(index + 1)) == quoteChar) {
                        this.buf.append(quoteChar);
                        return index + 1;
                    }
                    this.step = 3;
                    break;
                }
                index = this.parseCharAt(carac, line, index, escaped);
            }
        }
        this.previousWhite = false;
        return index;
    }

    private int parseCharAt(char carac, String line, int index, boolean escaped) {
        if (escaped && carac == '\\') {
            if (index < line.length() - 1) {
                char next = line.charAt(index + 1);
                if (next == 'n') {
                    this.buf.append('\n');
                } else if (next == 't') {
                    this.buf.append('\t');
                } else {
                    this.buf.append(next);
                }
                ++index;
            }
        } else {
            this.buf.append(carac);
        }
        return index;
    }

    private void flushValue() {
        this.resultList.add(this.buf.toString());
        this.buf = new StringBuilder();
    }

    private String[] flushCompleteValues() {
        if (this.buf.length() == 0 && this.resultList.isEmpty()) {
            return null;
        }
        this.flushValue();
        String[] resultArray = this.resultList.toArray(new String[this.resultList.size()]);
        this.resultList.clear();
        this.step = 5;
        return resultArray;
    }
}

