/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.text.collation.group;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import net.mapeadores.util.text.collation.group.CollationGroup;
import net.mapeadores.util.text.collation.group.ObjectWrapper;

class DefaultCollationGroup
implements CollationGroup {
    private final char initial;
    private final SortedMap<String, Object> sortedMap = new TreeMap<String, Object>();

    DefaultCollationGroup(char initial) {
        this.initial = initial;
    }

    @Override
    public char getInitial() {
        return this.initial;
    }

    @Override
    public List<ObjectWrapper> getSortedObjectWrapperList() {
        ArrayList<ObjectWrapper> result = new ArrayList<ObjectWrapper>();
        for (Object obj : this.sortedMap.values()) {
            if (obj instanceof List) {
                List currentList = (List)obj;
                result.addAll(currentList);
                continue;
            }
            result.add((ObjectWrapper)obj);
        }
        return result;
    }

    boolean isEmpty() {
        return this.sortedMap.isEmpty();
    }

    void addObject(String collationKey, ObjectWrapper objectWrapper) {
        Object obj = this.sortedMap.get(collationKey);
        if (obj == null) {
            this.sortedMap.put(collationKey, objectWrapper);
        } else if (obj instanceof List) {
            List currentList = (List)obj;
            this.addInList(currentList, objectWrapper);
        } else {
            ArrayList<ObjectWrapper> arrayList = new ArrayList<ObjectWrapper>();
            arrayList.add((ObjectWrapper)obj);
            this.addInList(arrayList, objectWrapper);
            this.sortedMap.put(collationKey, arrayList);
        }
    }

    private void addInList(List<ObjectWrapper> list, ObjectWrapper objectWrapper) {
        int size = list.size();
        String sourceString = objectWrapper.getSourceString();
        boolean done = false;
        for (int i = 0; i < size; ++i) {
            ObjectWrapper obj2 = list.get(i);
            if (obj2.getSourceString().compareTo(sourceString) <= 0) continue;
            list.add(i, objectWrapper);
            done = true;
            break;
        }
        if (!done) {
            list.add(objectWrapper);
        }
    }
}

