/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.request.xml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.request.RequestConfBuilder;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class RequestConfDOMReader {
    private final RequestConfBuilder requestConfBuilder;

    public RequestConfDOMReader(RequestConfBuilder requestConfBuilder) {
        this.requestConfBuilder = requestConfBuilder;
    }

    public void readConf(Element element) {
        DOMUtils.readChildren(element, new ConfConsumer());
    }

    private class ConfConsumer
    implements Consumer<Element> {
        private ConfConsumer() {
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("param")) {
                String name = element.getAttribute("name");
                if (name.length() > 0) {
                    String value = element.getAttribute("value");
                    if (value.length() > 0) {
                        RequestConfDOMReader.this.requestConfBuilder.addParameter(name, Collections.singleton(value));
                    } else {
                        ParameterValueConsumer parameterValueConsumer = new ParameterValueConsumer();
                        DOMUtils.readChildren(element, parameterValueConsumer);
                        if (parameterValueConsumer.isNotEmpty()) {
                            RequestConfDOMReader.this.requestConfBuilder.addParameter(name, parameterValueConsumer.getList());
                        }
                    }
                }
            } else if (tagName.equals("attr")) {
                AttributeUtils.readAttrElement(RequestConfDOMReader.this.requestConfBuilder.getAttributesBuilder(), element);
            }
        }
    }

    private class ParameterValueConsumer
    implements Consumer<Element> {
        private final List<String> values = new ArrayList<String>();

        @Override
        public void accept(Element element) {
            String val;
            String tagName = element.getTagName();
            if (tagName.equals("val") && (val = XMLUtils.getData(element)).length() > 0) {
                this.values.add(val);
            }
        }

        private boolean isNotEmpty() {
            return !this.values.isEmpty();
        }

        private List<String> getList() {
            return this.values;
        }
    }
}

