/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.request;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.mapeadores.util.request.FileValue;
import net.mapeadores.util.request.RequestMap;

public class TableIteratorRequestMap
implements RequestMap {
    private final ValueBuffer[] valueBufferArray;
    private final Map<String, ValueBuffer> valueBufferMap = new HashMap<String, ValueBuffer>();

    public TableIteratorRequestMap(String[] columnNameArray) {
        int length = columnNameArray.length;
        this.valueBufferArray = new ValueBuffer[length];
        for (int i = 0; i < length; ++i) {
            String name = columnNameArray[i];
            ValueBuffer valuesBuffer = this.valueBufferMap.get(name);
            if (valuesBuffer == null) {
                valuesBuffer = new ValueBuffer();
                this.valueBufferMap.put(name, valuesBuffer);
            }
            this.valueBufferArray[i] = valuesBuffer;
        }
    }

    @Override
    public FileValue getFileValue(String name) {
        return null;
    }

    @Override
    public FileValue[] getFileValues(String name) {
        return null;
    }

    @Override
    public String getParameter(String name) {
        ValueBuffer valueBuffer = this.valueBufferMap.get(name);
        if (valueBuffer == null) {
            return null;
        }
        return valueBuffer.getValue();
    }

    @Override
    public String[] getParameterValues(String name) {
        ValueBuffer valueBuffer = this.valueBufferMap.get(name);
        if (valueBuffer == null) {
            return null;
        }
        return valueBuffer.getValueArray();
    }

    @Override
    public Set<String> getParameterNameSet() {
        return this.valueBufferMap.keySet();
    }

    public void updateRow(String[] valueArray) {
        this.clear();
        int length = Math.min(valueArray.length, this.valueBufferArray.length);
        for (int i = 0; i < length; ++i) {
            this.valueBufferArray[i].add(valueArray[i]);
        }
    }

    public void clear() {
        for (ValueBuffer valueBuffer : this.valueBufferMap.values()) {
            valueBuffer.clear();
        }
    }

    @Override
    public Locale[] getAcceptableLocaleArray() {
        return null;
    }

    @Override
    public Object getSourceObject() {
        return null;
    }

    private static class ValueBuffer {
        private List<String> values = new ArrayList<String>();

        private ValueBuffer() {
        }

        private void clear() {
            this.values.clear();
        }

        private void add(String value) {
            this.values.add(value);
        }

        private String getValue() {
            if (this.values.isEmpty()) {
                return "";
            }
            return this.values.get(0);
        }

        private String[] getValueArray() {
            int size = this.values.size();
            if (size == 0) {
                String[] result = new String[]{""};
                return result;
            }
            String[] result = new String[size];
            for (int i = 0; i < size; ++i) {
                result[i] = this.values.get(i);
            }
            return result;
        }
    }
}

