/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.request;

import java.util.ArrayList;
import java.util.Locale;
import java.util.Set;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.request.FileValue;
import net.mapeadores.util.text.StringUtils;

public interface RequestMap {
    @Nullable
    public FileValue getFileValue(String var1);

    @Nullable
    public FileValue[] getFileValues(String var1);

    @Nullable
    public String getParameter(String var1);

    @Nullable
    public String[] getParameterValues(String var1);

    public Set<String> getParameterNameSet();

    @Nullable
    public Locale[] getAcceptableLocaleArray();

    @Nullable
    public Object getSourceObject();

    default public boolean isTrue(String name) {
        return StringUtils.isTrue(this.getParameter(name));
    }

    default public String getTrimedParameter(String name) {
        String value = this.getParameter(name);
        if (value == null) {
            return "";
        }
        return value.trim();
    }

    @Nullable
    default public String[] getParameterTokens(String name, boolean includeSpaceSeparator) {
        String[] values = this.getParameterValues(name);
        if (values == null) {
            return null;
        }
        if (values.length == 1) {
            return StringUtils.getTechnicalTokens(values[0], includeSpaceSeparator);
        }
        ArrayList<String> tokenList = new ArrayList<String>();
        for (String value : values) {
            String[] tokens;
            for (String token : tokens = StringUtils.getTechnicalTokens(value, includeSpaceSeparator)) {
                tokenList.add(token);
            }
        }
        return tokenList.toArray(new String[tokenList.size()]);
    }
}

