/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.primitives.io;

import java.io.DataInput;
import java.io.IOException;
import net.mapeadores.util.primitives.io.PrimitivesReader;

public class DataInputPrimitivesReader
implements PrimitivesReader {
    private final DataInput dataInput;

    public DataInputPrimitivesReader(DataInput dataInput) {
        this.dataInput = dataInput;
    }

    @Override
    public int readInt() throws IOException {
        return this.dataInput.readInt();
    }

    @Override
    public short readShort() throws IOException {
        return this.dataInput.readShort();
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.dataInput.readBoolean();
    }

    @Override
    public String readString() throws IOException {
        String s = this.dataInput.readUTF();
        if (s.equals("\u0000")) {
            return null;
        }
        return s;
    }

    @Override
    public char readChar() throws IOException {
        return this.dataInput.readChar();
    }

    @Override
    public double readDouble() throws IOException {
        return this.dataInput.readDouble();
    }

    @Override
    public long readLong() throws IOException {
        return this.dataInput.readLong();
    }

    @Override
    public byte readByte() throws IOException {
        return this.dataInput.readByte();
    }

    @Override
    public void read(byte[] buffer, int offset, int length) throws IOException {
        this.dataInput.readFully(buffer, offset, length);
    }

    @Override
    public float readFloat() throws IOException {
        return this.dataInput.readFloat();
    }

    @Override
    public int skipBytes(int length) throws IOException {
        return this.dataInput.skipBytes(length);
    }
}

