/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.primitives.io;

import java.io.IOException;
import java.io.RandomAccessFile;

public final class CacheRef {
    private final long position;
    private final int length;

    public CacheRef(long position, int length) {
        this.position = position;
        this.length = length;
    }

    public long getPosition() {
        return this.position;
    }

    public int getLength() {
        return this.length;
    }

    public static byte[] read(RandomAccessFile randomAccessFile, CacheRef cacheRef) throws IOException {
        randomAccessFile.seek(cacheRef.position);
        int cacheLength = cacheRef.length;
        byte[] cache = new byte[cacheLength];
        randomAccessFile.read(cache, 0, cacheLength);
        return cache;
    }

    public static CacheRef write(RandomAccessFile randomAccessFile, byte[] cache) throws IOException {
        long position = randomAccessFile.getFilePointer();
        int cacheLength = cache.length;
        randomAccessFile.write(cache, 0, cacheLength);
        return new CacheRef(position, cacheLength);
    }
}

