/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.jslib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import net.mapeadores.util.jslib.JsLib;
import net.mapeadores.util.jslib.TemplateFamily;
import net.mapeadores.util.jslib.ThirdLib;
import net.mapeadores.util.text.RelativePath;

public class JsLibAssembly {
    private final Set<JsLib> jsLibSet = new HashSet<JsLib>();
    private final Map<String, ThirdLibBuffer> thirdLibMap = new HashMap<String, ThirdLibBuffer>();
    private final SortedMap<String, TemplateFamily> templateMap = new TreeMap<String, TemplateFamily>();
    private final Set<RelativePath> jsScriptSet = new LinkedHashSet<RelativePath>();
    private final Set<String> cssPathSet = new LinkedHashSet<String>();

    public boolean hasTemplate() {
        return !this.templateMap.isEmpty();
    }

    public boolean hasThirdLib() {
        return !this.thirdLibMap.isEmpty();
    }

    public ThirdLib getThirdLib(String name) {
        return this.thirdLibMap.get(name);
    }

    public Collection<TemplateFamily> getTemplates() {
        return this.templateMap.values();
    }

    public Collection<RelativePath> getScriptPaths() {
        return this.jsScriptSet;
    }

    public Collection<String> getJsLibCssPaths() {
        return this.cssPathSet;
    }

    public void addJsLib(JsLib jsLib) {
        if (this.jsLibSet.contains(jsLib)) {
            return;
        }
        this.jsLibSet.add(jsLib);
        for (JsLib dependency : jsLib.getDependencyList()) {
            this.addJsLib(dependency);
        }
        for (RelativePath relativePath : jsLib.getJsScriptList()) {
            this.jsScriptSet.add(relativePath);
        }
        for (ThirdLib thirdLib : jsLib.getThirdLibList()) {
            String name = thirdLib.getName();
            ThirdLibBuffer buffer = this.thirdLibMap.get(name);
            if (buffer == null) {
                buffer = new ThirdLibBuffer(name);
                this.thirdLibMap.put(name, buffer);
            }
            buffer.addAll(thirdLib.getExtensionNameList());
        }
        for (TemplateFamily templateFamily : jsLib.getTemplateFamilyList()) {
            this.templateMap.put(templateFamily.getName(), templateFamily);
        }
        for (RelativePath cssPath : jsLib.getCssPathList()) {
            this.cssPathSet.add(cssPath.getPath());
        }
    }

    private static class ThirdLibBuffer
    implements ThirdLib {
        private final String name;
        private final List<String> extensionNameList = new ArrayList<String>();

        private ThirdLibBuffer(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public List<String> getExtensionNameList() {
            return this.extensionNameList;
        }

        private void addAll(Collection<String> extensionNames) {
            for (String extensionName : extensionNames) {
                if (this.extensionNameList.contains(extensionName)) continue;
                this.extensionNameList.add(extensionName);
            }
        }
    }
}

