/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.conditions;

import java.util.ArrayList;
import java.util.List;
import net.mapeadores.util.conditions.ConditionsUtils;
import net.mapeadores.util.conditions.TextCondition;
import net.mapeadores.util.conditions.TextTest;

public class TextConditionBuilder {
    private final String logicalOperator;
    private final List<TextTest> excludingList = new ArrayList<TextTest>();
    private final List<TextTest> includingList = new ArrayList<TextTest>();

    public TextConditionBuilder(String logicalOperator) {
        this.logicalOperator = logicalOperator;
    }

    public TextConditionBuilder addTextTest(String text) {
        TextTest textTest = ConditionsUtils.parseTextTest(text);
        if (textTest != null) {
            this.addTextTest(textTest);
        }
        return this;
    }

    public TextConditionBuilder addTextTest(TextTest textTest) {
        short testType = textTest.getTestType();
        if (ConditionsUtils.isExcludingPartTestType(testType)) {
            this.excludingList.add(ConditionsUtils.cloneTextTest(textTest));
        } else if (ConditionsUtils.isIncludingPartTestType(testType)) {
            this.includingList.add(ConditionsUtils.cloneTextTest(textTest));
        }
        return this;
    }

    public TextCondition toTextCondition() {
        TextTest[] excludingArray = this.excludingList.toArray(new TextTest[this.excludingList.size()]);
        TextTest[] includingArray = this.includingList.toArray(new TextTest[this.includingList.size()]);
        return new InternalTextCondition(this.logicalOperator, ConditionsUtils.wrap(excludingArray), ConditionsUtils.wrap(includingArray));
    }

    public static TextConditionBuilder init(String logicalOperator) {
        return new TextConditionBuilder(logicalOperator);
    }

    public static TextCondition build(TextTest textTest) {
        return TextConditionBuilder.init("and").addTextTest(textTest).toTextCondition();
    }

    private static class InternalTextCondition
    implements TextCondition {
        private final String logicalOperator;
        private final List<TextTest> excludingList;
        private final List<TextTest> includingList;

        public InternalTextCondition(String logicalOperator, List<TextTest> excludingList, List<TextTest> includingList) {
            this.logicalOperator = logicalOperator;
            this.excludingList = excludingList;
            this.includingList = includingList;
        }

        @Override
        public String getLogicalOperator() {
            return this.logicalOperator;
        }

        @Override
        public List<TextTest> getExcludingTextTestList() {
            return this.excludingList;
        }

        @Override
        public List<TextTest> getIncludingTextTestList() {
            return this.includingList;
        }
    }
}

