/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.opendocument.css.output;

import java.io.IOException;
import java.util.Map;
import net.mapeadores.opendocument.css.output.XMLWriter;
import net.mapeadores.opendocument.elements.Constants;
import net.mapeadores.opendocument.elements.ListLevelElement;
import net.mapeadores.opendocument.elements.ListStyleElement;
import net.mapeadores.opendocument.elements.OdAttribute;
import net.mapeadores.opendocument.elements.OdAttributeMap;
import net.mapeadores.opendocument.elements.OdElement;
import net.mapeadores.opendocument.elements.PropertiesElementUtils;
import net.mapeadores.opendocument.elements.StyleElement;

public class StylesXMLWriter
extends XMLWriter
implements Constants {
    public StylesXMLWriter(Appendable appendable, int indentValue) {
        super(appendable, indentValue);
    }

    public void openStyleDocument() throws IOException {
        this.startOpenTag("office:document-styles");
        this.appendNameSpaceAttributes();
        this.addAttribute("office:version", "1.0");
        this.endOpenTag();
    }

    public void appendNameSpaceAttributes() throws IOException {
        this.addAttribute("xmlns:office", "urn:oasis:names:tc:opendocument:xmlns:office:1.0");
        this.addAttribute("xmlns:style", "urn:oasis:names:tc:opendocument:xmlns:style:1.0");
        this.addAttribute("xmlns:text", "urn:oasis:names:tc:opendocument:xmlns:text:1.0");
        this.addAttribute("xmlns:table", "urn:oasis:names:tc:opendocument:xmlns:table:1.0");
        this.addAttribute("xmlns:draw", "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0");
        this.addAttribute("xmlns:fo", "urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0");
        this.addAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
    }

    public void closeStyleDocument() throws IOException {
        this.addEmptyElement("office:master-styles");
        this.closeTag("office:document-styles");
    }

    public void openStyles() throws IOException {
        this.openTag("office:styles");
    }

    public void closeStyles() throws IOException {
        this.closeTag("office:styles");
    }

    public void addStyleElement(StyleElement styleElement) throws IOException {
        this.startOpenTag("style:style");
        this.addAttribute("style:name", styleElement.getStyleName());
        this.addAttribute("style:family", styleElement.getStyleFamily());
        Map<OdAttribute, String> map = styleElement.getAttributeMap(1);
        if (map.size() > 0) {
            this.addAttributeMap(map);
        }
        this.endOpenTag();
        this.addPropertiesElementList(styleElement);
        this.closeTag("style:style");
    }

    public void addListStyleElement(ListStyleElement listStyleElement) throws IOException {
        this.startOpenTag("text:list-style");
        this.addAttribute("style:name", listStyleElement.getStyleName());
        Map<OdAttribute, String> map = listStyleElement.getAttributeMap(11);
        if (map.size() > 0) {
            this.addAttributeMap(map);
        }
        this.endOpenTag();
        for (int i = 1; i <= 10; ++i) {
            ListLevelElement listLevelElement = listStyleElement.getListLevelElement(i);
            if (listLevelElement == null) continue;
            this.addListLevelElement(listLevelElement);
        }
        this.closeTag("text:list-style");
    }

    public void addListLevelElement(ListLevelElement listLevelElement) throws IOException {
        String tagName = "text:list-level-style-";
        switch (listLevelElement.getType()) {
            case 1: {
                tagName = tagName + "bullet";
                break;
            }
            case 2: {
                tagName = tagName + "number";
            }
        }
        this.startOpenTag(tagName);
        this.addAttribute("text:level", String.valueOf(listLevelElement.getLevel()));
        Map<OdAttribute, String> map = listLevelElement.getAttributeMap(10);
        if (map.size() > 0) {
            this.addAttributeMap(map);
        }
        this.endOpenTag();
        this.addPropertiesElementList(listLevelElement);
        this.closeTag(tagName);
    }

    public void addPropertiesElementList(OdElement abstractElement) throws IOException {
        for (int i = 0; i < PropertiesElementUtils.count(); ++i) {
            int type = PropertiesElementUtils.getAttributesType(i);
            String tagName = PropertiesElementUtils.getTagName(i);
            Map<OdAttribute, String> map = abstractElement.getAttributeMap(type);
            if (map.size() == 0) continue;
            this.startOpenTag(tagName);
            this.addAttributeMap(map);
            this.closeEmptyTag();
        }
    }

    public void addAttributeMap(Map<OdAttribute, String> map) throws IOException {
        for (Map.Entry<OdAttribute, String> mapEntry : map.entrySet()) {
            OdAttribute propertiesAttribute = mapEntry.getKey();
            String value = mapEntry.getValue();
            this.addAttribute(propertiesAttribute, value);
        }
    }

    public void addAttribute(OdAttribute propertiesAttribute, String value) throws IOException {
        short nameSpace = propertiesAttribute.getNameSpace();
        String name = propertiesAttribute.getName();
        this.addAttribute(OdAttributeMap.nameSpaceToString(nameSpace) + ":" + name, value);
    }
}

