/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.xml.extraction;

import java.io.IOException;
import java.util.Map;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.extraction.ExtractParameters;
import net.fichotheque.extraction.ExtractionContext;
import net.fichotheque.extraction.def.CorpusExtractDef;
import net.fichotheque.extraction.def.PackClause;
import net.fichotheque.extraction.def.TagNameInfo;
import net.fichotheque.extraction.def.TitleClause;
import net.fichotheque.extraction.filterunit.FilterUnit;
import net.fichotheque.extraction.run.CorpusExtractResult;
import net.fichotheque.extraction.run.FicheExtractInfo;
import net.fichotheque.extraction.run.FicheGroup;
import net.fichotheque.utils.ExtractionUtils;
import net.fichotheque.utils.FichothequeUtils;
import net.fichotheque.xml.extraction.ExtractionXMLUtils;
import net.fichotheque.xml.extraction.FicheItemXMLPart;
import net.fichotheque.xml.extraction.FicheXMLPart;
import net.fichotheque.xml.extraction.TagNames;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LangContext;
import net.mapeadores.util.localisation.ListLangContext;
import net.mapeadores.util.localisation.UserLangContext;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLWriter;

public class CorpusExtractXMLPart
extends XMLPart {
    private final ExtractParameters extractParameters;
    private final int extractVersion;
    private final FicheXMLPart ficheXMLPart;
    private final FicheItemXMLPart ficheItemXMLPart;
    private final PackWriter packWriter = new PackWriter();
    private final TagNames tagNames;

    public CorpusExtractXMLPart(XMLWriter xmlWriter, ExtractParameters extractParameters) {
        super(xmlWriter);
        this.extractParameters = extractParameters;
        this.extractVersion = extractParameters.getExtractVersion();
        this.ficheXMLPart = new FicheXMLPart(xmlWriter, extractParameters);
        this.ficheItemXMLPart = new FicheItemXMLPart(xmlWriter, extractParameters);
        this.tagNames = new TagNames(this.extractVersion);
    }

    public void addCorpusExtract(CorpusExtractResult corpusExtractResult) throws IOException {
        this.addCorpusExtract(corpusExtractResult, null);
    }

    public void addCorpusExtract(CorpusExtractResult corpusExtractResult, FilterUnit filterUnit) throws IOException {
        boolean withTag;
        CorpusExtractDef corpusExtractDef = corpusExtractResult.getCorpusExtractDef();
        if (corpusExtractResult.isEmpty() && this.extractParameters.hideIfEmpty(filterUnit)) {
            return;
        }
        String tagName = this.getTagName(corpusExtractDef.getTagNameInfo());
        boolean bl = withTag = tagName != null;
        if (corpusExtractResult instanceof CorpusExtractResult.Named) {
            if (withTag) {
                String name = corpusExtractDef.getName();
                this.startOpenTag(tagName);
                this.addAttribute("name", name);
                if (this.extractVersion == 1) {
                    this.addAttribute("extrait-name", name);
                }
                ExtractionXMLUtils.addFilterParameters(this, filterUnit);
                ExtractionXMLUtils.addCellMax(this, corpusExtractDef.getFicheFilter());
                this.endOpenTag();
            }
            this.packWriter.setCurrentPackClause(corpusExtractDef.getPackClause());
            for (FicheGroup ficheGroup : ((CorpusExtractResult.Named)corpusExtractResult).getGroupList()) {
                this.addGroup(ficheGroup);
            }
            this.packWriter.flush();
            if (withTag) {
                this.closeTag(tagName);
            }
        } else {
            TitleClause titleClause = corpusExtractDef.getTitleClause();
            boolean withCorpusTitle = titleClause != null && titleClause.withTitle();
            for (CorpusExtractResult.Entry entry : ((CorpusExtractResult.Unnamed)corpusExtractResult).getEntryList()) {
                Corpus corpus = entry.getCorpus();
                if (withTag) {
                    this.startOpenTag(tagName);
                    this.addAttribute("corpus", corpus.getSubsetName());
                    ExtractionXMLUtils.addFilterParameters(this, filterUnit);
                    ExtractionXMLUtils.addCellMax(this, corpusExtractDef.getFicheFilter());
                    this.endOpenTag();
                }
                this.packWriter.setCurrentPackClause(corpusExtractDef.getPackClause());
                for (FicheGroup ficheGroup : entry.getGroupList()) {
                    this.addGroup(ficheGroup);
                }
                this.packWriter.flush();
                if (withCorpusTitle) {
                    this.addCorpusTitle(corpus);
                }
                if (!withTag) continue;
                this.closeTag(tagName);
            }
        }
    }

    private void addGroup(FicheGroup group) throws IOException {
        String tagName = this.getGroupTagName(group.getTagNameInfo());
        if (tagName != null) {
            String name = group.getName();
            this.startOpenTag(tagName);
            this.addAttribute("name", name);
            Map<String, String> attributesMap = group.getAttributesMap();
            if (attributesMap != null) {
                for (Map.Entry<String, String> mapEntry : attributesMap.entrySet()) {
                    this.addAttribute(mapEntry.getKey(), mapEntry.getValue());
                }
            }
            this.endOpenTag();
            FicheItem[] matchingFicheItemArray = group.getMatchingFicheItemArray();
            if (matchingFicheItemArray != null) {
                for (FicheItem ficheItem : matchingFicheItemArray) {
                    this.ficheItemXMLPart.addFicheItem(ficheItem, null, ExtractionUtils.SAME_CONVERTER);
                }
            }
        }
        if (group.isBottomGroup()) {
            FicheExtractInfo[] array = group.getFicheExtractInfoArray();
            if (array != null) {
                for (FicheExtractInfo ficheExtractInfo : array) {
                    this.packWriter.ficheStart();
                    this.ficheXMLPart.addFiche(ficheExtractInfo);
                    this.packWriter.ficheEnd();
                }
            }
        } else {
            FicheGroup[] subgroupArray = group.getSubgroupArray();
            if (subgroupArray != null) {
                for (FicheGroup ficheGroup : subgroupArray) {
                    this.addGroup(ficheGroup);
                }
            }
        }
        if (tagName != null) {
            this.packWriter.groupFlush();
            this.closeTag(tagName);
        }
    }

    private void addCorpusTitle(Corpus corpus) throws IOException {
        ExtractionContext extractionContext = this.extractParameters.getExtractionContext();
        String titleTagName = this.tagNames.getSubsetTitleTagName();
        this.openTag(titleTagName);
        LangContext langContext = extractionContext.getLangContext();
        if (langContext instanceof ListLangContext) {
            for (ListLangContext.Unit unit : (ListLangContext)langContext) {
                Lang lang = unit.getLang();
                String title = FichothequeUtils.getTitle(corpus, lang);
                LabelUtils.addLabel(this, lang, title);
            }
        } else if (langContext instanceof UserLangContext) {
            UserLangContext userLangContext = (UserLangContext)langContext;
            Lang workingLang = userLangContext.getWorkingLang();
            String title = FichothequeUtils.getTitle(corpus, workingLang);
            LabelUtils.addLabel(this, null, title);
        }
        this.closeTag(titleTagName);
    }

    private String getTagName(TagNameInfo tagNameInfo) {
        switch (tagNameInfo.getType()) {
            case 3: {
                return tagNameInfo.getCustomTagName();
            }
            case 2: {
                return null;
            }
        }
        return this.tagNames.getSubsetTagName((short)1);
    }

    private String getGroupTagName(TagNameInfo tagNameInfo) {
        switch (tagNameInfo.getType()) {
            case 3: {
                return tagNameInfo.getCustomTagName();
            }
            case 2: {
                return null;
            }
        }
        return "group";
    }

    private String getPackTagName(TagNameInfo tagNameInfo) {
        switch (tagNameInfo.getType()) {
            case 3: {
                return tagNameInfo.getCustomTagName();
            }
            case 2: {
                return null;
            }
        }
        return "pack";
    }

    private class PackWriter {
        private PackClause packClause;
        private String tagName;
        private int packSize;
        private int counter = 0;
        private int modulo = 0;
        private int packCounter = 1;

        PackWriter() {
        }

        void setCurrentPackClause(PackClause newPackClause) {
            int ps;
            String tn;
            this.reset();
            if (newPackClause != null && (tn = CorpusExtractXMLPart.this.getPackTagName(newPackClause.getTagNameInfo())) != null && (ps = newPackClause.getPackSize()) > 0) {
                this.packClause = newPackClause;
                this.tagName = tn;
                this.packSize = ps;
                int m = newPackClause.getModulo();
                if (m < 2) {
                    m = 0;
                }
                this.modulo = m;
            }
        }

        public void ficheStart() throws IOException {
            if (!this.testPack()) {
                return;
            }
            if (this.counter == 0) {
                CorpusExtractXMLPart.this.startOpenTag(this.tagName);
                if (this.modulo > 0) {
                    CorpusExtractXMLPart.this.addAttribute("modulo-val", this.packCounter);
                    this.packCounter = this.packCounter == this.modulo ? 1 : ++this.packCounter;
                }
                CorpusExtractXMLPart.this.endOpenTag();
            }
            ++this.counter;
        }

        public void ficheEnd() throws IOException {
            if (!this.testPack()) {
                return;
            }
            if (this.counter == this.packSize) {
                CorpusExtractXMLPart.this.closeTag(this.tagName);
                this.counter = 0;
            }
        }

        public void groupFlush() throws IOException {
            if (!this.testPack()) {
                return;
            }
            if (this.counter > 0) {
                this.closePack();
            }
        }

        public void flush() throws IOException {
            if (!this.testPack()) {
                return;
            }
            if (this.counter > 0) {
                this.closePack();
            }
            this.reset();
        }

        private boolean testPack() {
            return this.packClause != null;
        }

        private void closePack() throws IOException {
            CorpusExtractXMLPart.this.closeTag(this.tagName);
            this.counter = 0;
        }

        private void reset() {
            this.packClause = null;
            this.tagName = null;
            this.counter = 0;
            this.packSize = 0;
            this.modulo = 0;
            this.packCounter = 1;
        }
    }
}

