/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.selection;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.fichotheque.selection.CroisementCondition;
import net.fichotheque.selection.RangeCondition;
import net.mapeadores.util.text.StringUtils;

public class CroisementConditionBuilder {
    private final Set<String> modeSet = new LinkedHashSet<String>();
    private RangeCondition weightRangeCondition = null;

    public CroisementConditionBuilder addLienMode(String mode) {
        if (mode.equals("_default")) {
            mode = "";
        }
        this.modeSet.add(mode);
        return this;
    }

    public CroisementConditionBuilder setWeightRangeCondition(RangeCondition weightRangeCondition) {
        this.weightRangeCondition = weightRangeCondition;
        return this;
    }

    public boolean isEmpty() {
        return this.weightRangeCondition == null && this.modeSet.isEmpty();
    }

    public CroisementCondition toCroisementCondition() {
        int size = this.modeSet.size();
        List<String> lienModeList = size > 0 ? StringUtils.wrap(this.modeSet.toArray(new String[size])) : StringUtils.EMPTY_STRINGLIST;
        return new InternalCroisementCondition(lienModeList, this.weightRangeCondition);
    }

    public static CroisementConditionBuilder init() {
        return new CroisementConditionBuilder();
    }

    private static class InternalCroisementCondition
    implements CroisementCondition {
        private final List<String> lienModeList;
        private final RangeCondition weightRangeCondition;

        private InternalCroisementCondition(List<String> lienModeList, RangeCondition weightRangeCondition) {
            this.lienModeList = lienModeList;
            this.weightRangeCondition = weightRangeCondition;
        }

        @Override
        public List<String> getLienModeList() {
            return this.lienModeList;
        }

        @Override
        public RangeCondition getWeightRangeCondition() {
            return this.weightRangeCondition;
        }
    }
}

