/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.parsers.ficheblock;

import java.text.ParseException;
import java.util.ArrayList;
import net.fichotheque.corpus.fiche.Atts;
import net.fichotheque.corpus.fiche.Div;
import net.fichotheque.corpus.fiche.FicheBlock;
import net.fichotheque.tools.parsers.TextContentParser;
import net.fichotheque.tools.parsers.ficheblock.BlockParser;
import net.fichotheque.tools.parsers.ficheblock.FicheBlockParser;
import net.fichotheque.utils.FicheUtils;
import net.mapeadores.util.html.HtmlCleaner;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.StringUtils;
import net.mapeadores.util.text.TypoOptions;

class DivParser
extends BlockParser {
    private final TextContentParser textContentParser;
    private final TypoOptions typoOptions;
    private final HtmlCleaner htmlCleaner;
    private final boolean withLineNumber;

    DivParser(TextContentParser textContentParser, TypoOptions typoOptions, HtmlCleaner htmlCleaner, boolean withLineNumber) {
        this.textContentParser = textContentParser;
        this.typoOptions = typoOptions;
        this.htmlCleaner = htmlCleaner;
        this.withLineNumber = withLineNumber;
    }

    @Override
    public boolean isStartLine(String line) {
        return line.startsWith("!!!");
    }

    @Override
    public void parse(String[] lineArray, int startIndex, Atts initAtts) {
        String params;
        Div div = new Div();
        String firstLine = lineArray[startIndex];
        if (firstLine.length() > 3 && (params = firstLine.substring(3).trim()).length() > 0) {
            try {
                Lang lang = Lang.parse(params);
                div.setLang(lang);
            }
            catch (ParseException lang) {
                // empty catch block
            }
        }
        FicheUtils.populate(div, initAtts);
        int beginIndex = BlockParser.parseZoneBlockElements(div, startIndex + 1, lineArray, this.textContentParser);
        int stop = lineArray.length - 1;
        ArrayList<FicheBlock> list = new ArrayList<FicheBlock>();
        FicheBlockParser ficheBlockParser = new FicheBlockParser(this.htmlCleaner, this.typoOptions, this.withLineNumber);
        for (int i = beginIndex; i <= stop; ++i) {
            String line = StringUtils.cleanString(lineArray[i]);
            if (line.startsWith("!!!")) {
                stop = i;
                break;
            }
            i = ficheBlockParser.parseLine(lineArray, i, list);
        }
        for (FicheBlock ficheBlock : list) {
            div.add(ficheBlock);
        }
        list.clear();
        this.setParseResult(stop, div);
    }
}

