/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.parsers;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.fichotheque.corpus.fiche.Atts;
import net.fichotheque.tools.parsers.AttsParser;

public class LineInfo {
    public static final List<Atts> EMPTY_ATTSLIST = Collections.emptyList();
    public static final String LINENUMBER_DATA = "data-bdf-linenumber";
    private final List<Atts> attsList;
    private final String cleanedLine;
    private final boolean attsError;

    private LineInfo(String line, List<Atts> attsList, boolean attsError) {
        this.cleanedLine = line;
        this.attsList = attsList;
        this.attsError = attsError;
    }

    public boolean isCleanedLineEmpty() {
        return this.cleanedLine.length() == 0;
    }

    public List<Atts> getAttsList() {
        return this.attsList;
    }

    public Atts getFirstAtts() {
        if (this.attsList.isEmpty()) {
            return null;
        }
        return this.attsList.get(0);
    }

    public Atts getSecondAtts() {
        if (this.attsList.size() < 2) {
            return null;
        }
        return this.attsList.get(1);
    }

    public String getCleanedLine() {
        return this.cleanedLine;
    }

    public boolean hasAttsError() {
        return this.attsError;
    }

    public LineInfo deriveWithoutAttsList() {
        if (this.attsList.isEmpty() && !this.attsError) {
            return this;
        }
        return new LineInfo(this.cleanedLine, EMPTY_ATTSLIST, false);
    }

    public static LineInfo parse(String line, int lineIndex) {
        String lineNumber = null;
        if (lineIndex > -1) {
            lineNumber = String.valueOf(lineIndex + 1);
        }
        if (line.length() == 0) {
            return new LineInfo("", LineInfo.toAttsList(lineNumber), false);
        }
        if (!line.startsWith("[(")) {
            return new LineInfo(line, LineInfo.toAttsList(lineNumber), false);
        }
        try {
            return LineInfo.parseWithAttsList(line, lineNumber);
        }
        catch (ParseException pe) {
            return new LineInfo(line, LineInfo.toAttsList(lineNumber), true);
        }
    }

    public static Atts getAutomaticAtts(int lineIndex) {
        if (lineIndex > -1) {
            return new LineNumberAtts(String.valueOf(lineIndex + 1));
        }
        return null;
    }

    private static LineInfo parseWithAttsList(String line, String lineNumber) throws ParseException {
        int closeIndex;
        ArrayList<Atts> attsList;
        block3: {
            attsList = new ArrayList<Atts>();
            int startIndex = 2;
            closeIndex = -1;
            while (true) {
                AttsParser parser = new AttsParser(line, startIndex);
                if (lineNumber != null) {
                    parser.addAtt(LINENUMBER_DATA, lineNumber);
                }
                parser.run();
                closeIndex = parser.getCloseIndex();
                if (closeIndex == line.length() - 1) {
                    throw new ParseException("Missing closing ]", closeIndex);
                }
                attsList.add(parser.getAtts());
                char nextChar = line.charAt(closeIndex + 1);
                if (nextChar == ']') break block3;
                if (nextChar != '(') break;
                startIndex = closeIndex + 2;
            }
            throw new ParseException("Missing ] or (", closeIndex + 1);
        }
        String newLine = line.length() > closeIndex + 2 && line.charAt(closeIndex + 2) == ' ' ? line.substring(closeIndex + 3) : line.substring(closeIndex + 2);
        return new LineInfo(newLine, attsList, false);
    }

    private static List<Atts> toAttsList(String lineNumber) {
        if (lineNumber != null) {
            return Collections.singletonList(new LineNumberAtts(lineNumber));
        }
        return EMPTY_ATTSLIST;
    }

    private static class LineNumberAtts
    implements Atts {
        private final String lineNumber;

        private LineNumberAtts(String lineNumber) {
            this.lineNumber = lineNumber;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public String getName(int index) {
            return LineInfo.LINENUMBER_DATA;
        }

        @Override
        public String getValue(int index) {
            return this.lineNumber;
        }

        @Override
        public boolean hasOnlyAutomaticAtts() {
            return true;
        }
    }
}

