/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.parsers;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.fichotheque.Fichotheque;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.fiche.AmountItem;
import net.fichotheque.corpus.fiche.CountryItem;
import net.fichotheque.corpus.fiche.DateItem;
import net.fichotheque.corpus.fiche.EmailItem;
import net.fichotheque.corpus.fiche.FicheBlock;
import net.fichotheque.corpus.fiche.FicheBlocks;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.FicheItems;
import net.fichotheque.corpus.fiche.GeopointItem;
import net.fichotheque.corpus.fiche.ImageItem;
import net.fichotheque.corpus.fiche.Item;
import net.fichotheque.corpus.fiche.LanguageItem;
import net.fichotheque.corpus.fiche.LinkItem;
import net.fichotheque.corpus.fiche.NumberItem;
import net.fichotheque.corpus.fiche.ParaItem;
import net.fichotheque.corpus.fiche.PersonItem;
import net.fichotheque.corpus.metadata.AmountSubfieldKey;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.corpus.metadata.SubfieldKey;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.tools.corpus.FicheChangeBuilder;
import net.fichotheque.tools.parsers.TextContentParser;
import net.fichotheque.tools.parsers.TypoParser;
import net.fichotheque.tools.parsers.ficheblock.FicheBlockParser;
import net.fichotheque.utils.FicheUtils;
import net.fichotheque.utils.SphereUtils;
import net.mapeadores.util.conditions.ConditionsUtils;
import net.mapeadores.util.conditions.TextCondition;
import net.mapeadores.util.conditions.TextConditionBuilder;
import net.mapeadores.util.conditions.TextTest;
import net.mapeadores.util.html.HtmlCleaner;
import net.mapeadores.util.localisation.CodeCatalog;
import net.mapeadores.util.localisation.Country;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.UserLangContext;
import net.mapeadores.util.models.EmailCore;
import net.mapeadores.util.models.EmailCoreUtils;
import net.mapeadores.util.models.PersonCore;
import net.mapeadores.util.models.PersonCoreUtils;
import net.mapeadores.util.money.Currencies;
import net.mapeadores.util.money.ExtendedCurrency;
import net.mapeadores.util.money.MoneyUtils;
import net.mapeadores.util.primitives.Decimal;
import net.mapeadores.util.primitives.DegreDecimal;
import net.mapeadores.util.primitives.DegreSexagesimal;
import net.mapeadores.util.primitives.FuzzyDate;
import net.mapeadores.util.text.CleanedString;
import net.mapeadores.util.text.DateFormatBundle;
import net.mapeadores.util.text.StringUtils;
import net.mapeadores.util.text.TypoOptions;

public class FicheParser {
    private final Parameters parameters;
    private final Fichotheque fichotheque;
    private final FicheChangeBuilder ficheChangeBuilder;
    private final FicheBlockParser ficheBlockParser;
    private final DateFormatBundle dateFormatBundle;
    private final TypoOptions typoOptions;
    private final TextContentParser textContentParser;
    private final Map<FieldKey, SubfieldBuffer> subfieldBufferMap = new HashMap<FieldKey, SubfieldBuffer>();
    private SubsetKey defaultSphereKey = null;

    public FicheParser(Parameters parameters, Corpus corpus, FicheChangeBuilder ficheChangeBuilder) {
        this.parameters = parameters;
        this.ficheChangeBuilder = ficheChangeBuilder;
        this.dateFormatBundle = DateFormatBundle.getDateFormatBundle(parameters.getUserLangContext().getFormatLocale());
        Redacteur userRedacteur = parameters.getUserRedacteur();
        if (userRedacteur != null) {
            this.defaultSphereKey = userRedacteur.getSubsetKey();
        }
        this.typoOptions = parameters.getTypoOptions();
        this.fichotheque = corpus.getFichotheque();
        this.textContentParser = new TextContentParser(this.typoOptions);
        this.ficheBlockParser = new FicheBlockParser(parameters.getHtmlCleaner(), this.typoOptions, false);
    }

    public void flushParsedSubfields() {
        for (SubfieldBuffer subfieldBuffer : this.subfieldBufferMap.values()) {
            subfieldBuffer.flush();
        }
    }

    public void parseCorpusField(CorpusField corpusField, String value) {
        block0 : switch (corpusField.getCategory()) {
            case 1: {
                this.parseProp(corpusField, this.cleanPropToken(value, this.parameters.getItemListSeparateur()));
                break;
            }
            case 2: {
                String[] tokens = StringUtils.getTechnicalTokens(value, this.parameters.getItemListSeparateur(), false);
                this.parseInfo(corpusField, tokens);
                break;
            }
            case 3: {
                this.parseSection(corpusField, value);
                break;
            }
            case 0: {
                switch (corpusField.getFieldString()) {
                    case "title": {
                        this.parseTitle(value);
                        break block0;
                    }
                    case "subtitle": {
                        this.parseSubtitle(value);
                        break block0;
                    }
                    case "lang": {
                        this.parseFicheLang(value);
                        break block0;
                    }
                    case "owners": {
                        String[] ownerTokens = StringUtils.getTechnicalTokens(value, this.parameters.getItemListSeparateur(), false);
                        this.parseOwners(ownerTokens);
                        break block0;
                    }
                }
            }
        }
    }

    public void parseSubfield(CorpusField corpusField, SubfieldKey subfieldKey, String value) {
        if (SubfieldKey.isLegalSubfield(corpusField, subfieldKey.getSubtype())) {
            SubfieldBuffer fieldBuffer = this.subfieldBufferMap.get(corpusField.getFieldKey());
            if (fieldBuffer == null) {
                fieldBuffer = new SubfieldBuffer(corpusField);
                this.subfieldBufferMap.put(corpusField.getFieldKey(), fieldBuffer);
            }
            fieldBuffer.putSubfield(subfieldKey, value);
        }
    }

    public void parseFicheLang(String s) {
        if (s == null) {
            return;
        }
        LanguageItem langue = this.parseLanguage(s);
        if (langue != null) {
            this.ficheChangeBuilder.setLang(langue.getLang());
        } else {
            this.ficheChangeBuilder.setLang(null);
        }
    }

    public void parseTitle(String s) {
        this.ficheChangeBuilder.setTitle(CleanedString.newInstance(TypoParser.parseTypo(s, this.typoOptions)));
    }

    public void parseSubtitle(String s) {
        CleanedString cs = CleanedString.newInstance(s);
        if (cs != null) {
            this.ficheChangeBuilder.setSubtitle(this.parsePara(cs.toString()));
        } else {
            this.ficheChangeBuilder.setSubtitle(null);
        }
    }

    public void parseOwners(String[] tokens) {
        FicheItems ficheItems = FicheParser.parsePersonList(tokens, this.fichotheque, this.defaultSphereKey, this.typoOptions);
        this.ficheChangeBuilder.putOwners(ficheItems);
    }

    public void parseProp(CorpusField propField, String s) {
        s = StringUtils.cleanString(s);
        FicheItem ficheItem = null;
        if (s.length() > 0) {
            ficheItem = this.parseFicheItem(s, propField);
        }
        this.ficheChangeBuilder.setProp(propField.getFieldKey(), ficheItem);
    }

    public void parsePersonProp(CorpusField propField, String surname, String forename, String nonlatin, String surnameFirstString) {
        surname = StringUtils.cleanString(surname);
        forename = StringUtils.cleanString(forename);
        nonlatin = StringUtils.cleanString(nonlatin);
        boolean surnameFirst = StringUtils.isTrue(surnameFirstString);
        FicheItem redacteurItem = this.parsePerson(surname, forename, nonlatin, surnameFirst);
        this.ficheChangeBuilder.setProp(propField.getFieldKey(), redacteurItem);
    }

    public void parseAmountProp(CorpusField propField, String value, String cur) {
        Serializable ficheItem = null;
        boolean itemAllowed = true;
        if ((value = StringUtils.cleanString(value)).length() > 0) {
            ficheItem = this.parseAmount(value);
            if (ficheItem == null) {
                if ((cur = StringUtils.cleanString(cur)).length() == 0) {
                    Currencies currencies = propField.getCurrencies();
                    cur = ((ExtendedCurrency)currencies.get(0)).getCurrencyCode();
                }
                ficheItem = this.parseAmount(value, cur);
            }
            if (ficheItem == null) {
                if (itemAllowed && !value.startsWith("?")) {
                    value = "?" + value;
                }
                ficheItem = this.parseItem(value, itemAllowed);
            }
        }
        this.ficheChangeBuilder.setProp(propField.getFieldKey(), (FicheItem)((Object)ficheItem));
    }

    public void parseImageProp(CorpusField propField, String src, String alt, String title) {
        ImageItem image = null;
        if ((src = StringUtils.cleanString(src)).length() > 0) {
            alt = StringUtils.cleanString(alt);
            title = StringUtils.cleanString(title);
            image = new ImageItem(src, alt, title);
        }
        this.ficheChangeBuilder.setProp(propField.getFieldKey(), image);
    }

    public void parseGeopointProp(CorpusField propField, String latitude, String longitude) {
        latitude = StringUtils.cleanString(latitude);
        longitude = StringUtils.cleanString(longitude);
        DegreDecimal latitudeDecimal = this.parseDegreDecimal(latitude);
        DegreDecimal longitudeDecimal = this.parseDegreDecimal(longitude);
        Serializable ficheItem = null;
        boolean itemAllowed = true;
        if (latitudeDecimal != null && longitudeDecimal != null) {
            ficheItem = new GeopointItem(latitudeDecimal, longitudeDecimal);
        } else if (latitude.length() > 0 || longitude.length() > 0) {
            if (itemAllowed && !latitude.startsWith("?? ")) {
                latitude = "?? " + latitude;
            }
            ficheItem = this.parseItem(latitude + " ?? " + longitude, itemAllowed);
        }
        this.ficheChangeBuilder.setProp(propField.getFieldKey(), (FicheItem)((Object)ficheItem));
    }

    public void parseInfo(CorpusField infoField, String[] tokens) {
        ArrayList<FicheItem> ficheItemCollection = new ArrayList<FicheItem>();
        for (String token : tokens) {
            FicheItem ficheItem = this.parseFicheItem(token, infoField);
            if (ficheItem == null) continue;
            ficheItemCollection.add(ficheItem);
        }
        this.addInInfo(infoField, FicheUtils.toFicheItems(ficheItemCollection));
    }

    public void addInInfo(CorpusField infoField, FicheItems ficheItems) {
        this.ficheChangeBuilder.putInfo(infoField.getFieldKey(), ficheItems);
    }

    public void parseSection(CorpusField sectionField, String s) {
        ArrayList<FicheBlock> list = new ArrayList<FicheBlock>();
        this.ficheBlockParser.parseFicheBlockList(s, list);
        FicheBlocks ficheBlocks = FicheUtils.toFicheBlocks(list);
        this.ficheChangeBuilder.putSection(sectionField.getFieldKey(), ficheBlocks);
    }

    public FicheItem parseFicheItem(String token, CorpusField corpusField) {
        boolean itemAllowed = true;
        switch (corpusField.getFicheItemType()) {
            case "language": {
                LanguageItem languageItem = this.parseLanguage(token);
                if (languageItem != null) {
                    return languageItem;
                }
                return this.parseItem(token, itemAllowed);
            }
            case "country": {
                CountryItem countryItem = this.parseCountry(token);
                if (countryItem != null) {
                    return countryItem;
                }
                return this.parseItem(token, itemAllowed);
            }
            case "date": {
                try {
                    FuzzyDate date = FuzzyDate.parse(token, this.dateFormatBundle);
                    return new DateItem(date);
                }
                catch (ParseException pe) {
                    return this.parseItem(token, itemAllowed);
                }
            }
            case "link": {
                LinkItem link = this.parseLink(token);
                if (link != null) {
                    return link;
                }
                return this.parseItem(token, itemAllowed);
            }
            case "number": {
                try {
                    Decimal decimal = StringUtils.parseDecimal(token);
                    return new NumberItem(decimal);
                }
                catch (NumberFormatException nfe) {
                    if (itemAllowed && !token.startsWith("?")) {
                        token = "?" + token;
                    }
                    return this.parseItem(token, itemAllowed);
                }
            }
            case "amount": {
                AmountItem amountItem = this.parseAmount(token);
                if (amountItem != null) {
                    return amountItem;
                }
                if (itemAllowed && !token.startsWith("?")) {
                    token = "?" + token;
                }
                return this.parseItem(token, itemAllowed);
            }
            case "email": {
                try {
                    EmailCore emailCore = EmailCoreUtils.parse(token);
                    return new EmailItem(emailCore);
                }
                catch (ParseException pe) {
                    return this.parseItem(token, itemAllowed);
                }
            }
            case "person": {
                return FicheParser.parsePerson(token, this.fichotheque, this.getDefaultSphereKey(corpusField), this.typoOptions);
            }
            case "item": {
                return new Item(TypoParser.parseTypo(token, this.typoOptions));
            }
            case "geopoint": {
                GeopointItem geopoint = this.parseGeopoint(token);
                if (geopoint != null) {
                    return geopoint;
                }
                return this.parseItem(token, itemAllowed);
            }
            case "para": {
                return this.parsePara(token);
            }
            case "image": {
                ImageItem image = this.parseImage(token);
                if (image != null) {
                    return image;
                }
                return this.parseItem(token, itemAllowed);
            }
        }
        return null;
    }

    private ParaItem parsePara(String token) {
        ParaItem.Builder paraBuilder = new ParaItem.Builder();
        this.textContentParser.parse(paraBuilder, token);
        return paraBuilder.toParaItem();
    }

    private FicheItem parsePerson(String surname, String forename, String nonlatin, boolean surnameFirst) {
        block4: {
            if (forename.length() == 0 && nonlatin.length() == 0) {
                try {
                    Redacteur redacteur = SphereUtils.parse(this.fichotheque, surname);
                    return new PersonItem(redacteur.getGlobalId());
                }
                catch (SphereUtils.RedacteurLoginException redacteurLoginException) {
                    if (surname.length() == 0) {
                        return null;
                    }
                    if (surnameFirst) break block4;
                    return new Item(TypoParser.parseTypo(surname, this.typoOptions));
                }
            }
        }
        surname = TypoParser.parseTypo(surname, this.typoOptions);
        forename = TypoParser.parseTypo(forename, this.typoOptions);
        nonlatin = TypoParser.parseTypo(nonlatin, this.typoOptions);
        return new PersonItem(PersonCoreUtils.toPersonCore(surname, forename, nonlatin, surnameFirst), null);
    }

    public FicheItem parseAmountInfoSubfield(CorpusField corpusField, ExtendedCurrency currency, String value) {
        value = StringUtils.cleanString(value);
        boolean itemAllowed = true;
        if (value.isEmpty()) {
            return null;
        }
        try {
            Decimal decimal = StringUtils.parseDecimal(value);
            return new AmountItem(decimal, currency);
        }
        catch (NumberFormatException nfe) {
            if (itemAllowed && !value.startsWith("?")) {
                value = "?" + value;
            }
            return this.parseItem(value, itemAllowed);
        }
    }

    private Item parseItem(String token, boolean itemAllowed) {
        if (itemAllowed) {
            return new Item(TypoParser.parseTypo(token, this.typoOptions));
        }
        return null;
    }

    public LinkItem parseLink(String s) {
        String href;
        int separateurinterne = 42;
        int posseparateur = s.indexOf(separateurinterne);
        if (posseparateur == -1) {
            separateurinterne = 124;
            posseparateur = s.indexOf(separateurinterne);
        }
        if ((href = posseparateur == -1 ? s : s.substring(0, posseparateur).trim()).startsWith("www.")) {
            href = "http://" + href;
        }
        try {
            URI uri = new URI(href);
            if (uri.isAbsolute()) {
                URL url = uri.toURL();
                href = url.toString();
            } else {
                href = uri.toString();
            }
            String title = "";
            String comment = "";
            if (posseparateur > -1) {
                String bout = s.substring(posseparateur + 1).trim();
                int pos2 = bout.indexOf(separateurinterne);
                if (pos2 > -1) {
                    title = bout.substring(0, pos2).trim();
                    comment = bout.substring(pos2 + 1).trim();
                } else {
                    title = bout;
                }
            }
            return new LinkItem(href, TypoParser.parseTypo(title, this.typoOptions), TypoParser.parseTypo(comment, this.typoOptions));
        }
        catch (MalformedURLException | URISyntaxException e) {
            return null;
        }
    }

    public ImageItem parseImage(String s) {
        String src;
        int separateurinterne = 42;
        int posseparateur = s.indexOf(separateurinterne);
        String alt = "";
        String title = "";
        if (posseparateur == -1) {
            src = s;
        } else {
            src = s.substring(0, posseparateur).trim();
            int pos2 = s.indexOf(separateurinterne, posseparateur + 1);
            if (pos2 == -1) {
                alt = s.substring(posseparateur + 1).trim();
            } else {
                alt = s.substring(posseparateur + 1, pos2).trim();
                title = s.substring(pos2 + 1).trim();
            }
        }
        return new ImageItem(src, TypoParser.parseTypo(alt, this.typoOptions), TypoParser.parseTypo(title, this.typoOptions));
    }

    private GeopointItem parseGeopoint(String s) {
        DegreDecimal latitude = null;
        DegreDecimal longitude = null;
        int idxAster = s.indexOf(42);
        if (idxAster != -1) {
            latitude = this.parseDegreDecimal(s.substring(0, idxAster));
            longitude = this.parseDegreDecimal(s.substring(idxAster + 1));
        }
        if (latitude != null && longitude != null) {
            return new GeopointItem(latitude, longitude);
        }
        return null;
    }

    private DegreDecimal parseDegreDecimal(String s) {
        try {
            Decimal decimal = StringUtils.parseDecimal(s);
            return DegreDecimal.newInstance(decimal);
        }
        catch (NumberFormatException nfe) {
            try {
                DegreSexagesimal ds = DegreSexagesimal.parse(s);
                return DegreDecimal.newInstance(ds);
            }
            catch (ParseException pe) {
                return null;
            }
        }
    }

    private AmountItem parseAmount(String s) {
        String[] result = MoneyUtils.splitMoney(s);
        if (result == null) {
            return null;
        }
        return this.parseAmount(result[0], result[1]);
    }

    private AmountItem parseAmount(String valString, String curString) {
        try {
            Decimal decimal = StringUtils.parseDecimal(valString);
            ExtendedCurrency currency = ExtendedCurrency.parse(curString);
            return new AmountItem(decimal, currency);
        }
        catch (NumberFormatException | ParseException e) {
            return null;
        }
    }

    private LanguageItem parseLanguage(String valString) {
        try {
            Lang lang = Lang.parse(valString);
            return new LanguageItem(lang);
        }
        catch (ParseException mcle) {
            TextTest textTest = ConditionsUtils.parseTextTest(valString);
            if (textTest != null) {
                Iterator<String> iterator;
                TextCondition condition = TextConditionBuilder.build(textTest);
                Set<String> result = this.parameters.getCodeCatalog().getLangCodeSet(condition, this.parameters.getUserLangContext().getLangPreference());
                if (!result.isEmpty() && (iterator = result.iterator()).hasNext()) {
                    String code = iterator.next();
                    return new LanguageItem(Lang.build(code));
                }
            }
            return null;
        }
    }

    private CountryItem parseCountry(String valString) {
        try {
            Country country = Country.parse(valString);
            return new CountryItem(country);
        }
        catch (ParseException pe) {
            TextTest textTest = ConditionsUtils.parseTextTest(valString);
            if (textTest != null) {
                Iterator<String> iterator;
                TextCondition condition = TextConditionBuilder.build(textTest);
                Set<String> result = this.parameters.getCodeCatalog().getCountryCodeSet(condition, this.parameters.getUserLangContext().getLangPreference());
                if (!result.isEmpty() && (iterator = result.iterator()).hasNext()) {
                    String code = iterator.next();
                    return new CountryItem(Country.build(code));
                }
            }
            return null;
        }
    }

    private SubsetKey getDefaultSphereKey(CorpusField corpusField) {
        SubsetKey customSphereKey = corpusField.getDefaultSphereKey();
        if (customSphereKey == null) {
            customSphereKey = this.defaultSphereKey;
        }
        return customSphereKey;
    }

    private String cleanPropToken(String s, char itemListSeparateur) {
        char carac;
        int length;
        int p = length = s.length();
        for (int i = length - 1; i >= 0 && ((carac = s.charAt(i)) == itemListSeparateur || Character.isWhitespace(carac)); --i) {
            --p;
        }
        if (p == 0) {
            return "";
        }
        if (p == length) {
            return s;
        }
        return s.substring(0, p);
    }

    public static FicheItems parsePersonList(String[] tokens, Fichotheque fichotheque, SubsetKey defaultSphereKey, TypoOptions typoOptions) {
        ArrayList<FicheItem> list = new ArrayList<FicheItem>();
        for (String token : tokens) {
            FicheItem redacteurItem = FicheParser.parsePerson(token, fichotheque, defaultSphereKey, typoOptions);
            if (redacteurItem == null) continue;
            list.add(redacteurItem);
        }
        return FicheUtils.toFicheItems(list);
    }

    public static FicheItem parsePerson(String token, Fichotheque fichotheque, SubsetKey defaultSphereKey, TypoOptions typoOptions) {
        try {
            Redacteur redacteur = SphereUtils.parse(fichotheque, token, defaultSphereKey);
            return new PersonItem(redacteur.getGlobalId());
        }
        catch (SphereUtils.RedacteurLoginException rle) {
            PersonItem personItem = FicheParser.parsePerson(token, typoOptions);
            if (personItem != null) {
                return personItem;
            }
            return new Item(TypoParser.parseTypo(token, typoOptions));
        }
    }

    public static PersonItem parsePerson(String s, TypoOptions typoOptions) {
        int separateurinterne = 42;
        int posvirg = s.indexOf(separateurinterne);
        if (posvirg == -1) {
            separateurinterne = 124;
            posvirg = s.indexOf(separateurinterne);
        }
        if (posvirg > -1) {
            String surname = TypoParser.parseTypo(s, 0, posvirg, typoOptions);
            String forename = "";
            String organism = null;
            if (posvirg < s.length() - 1) {
                String suite = s.substring(posvirg + 1).trim();
                int pos2 = suite.indexOf(separateurinterne);
                if (pos2 > -1) {
                    forename = suite.substring(0, pos2);
                    if (pos2 < suite.length() - 1) {
                        organism = suite.substring(pos2 + 1);
                    }
                } else {
                    forename = suite;
                }
            }
            boolean surnameFirst = false;
            if (forename.length() > 0 && forename.charAt(0) == '%') {
                forename = forename.substring(1);
                surnameFirst = true;
            }
            forename = TypoParser.parseTypo(forename, typoOptions);
            PersonCore personCore = PersonCoreUtils.toPersonCore(surname, forename, "", surnameFirst);
            return new PersonItem(personCore, TypoParser.parseTypo(organism, typoOptions));
        }
        return null;
    }

    public static class Parameters {
        private final UserLangContext userLangContext;
        private final CodeCatalog codeCatalog;
        private final HtmlCleaner htmlCleaner;
        private final TypoOptions typoOptions;
        private char itemListSeparateur = (char)59;
        private Redacteur userRedacteur = null;

        public Parameters(UserLangContext userLangContext, CodeCatalog codeCatalog, HtmlCleaner htmlCleaner, TypoOptions typoOptions) {
            this.userLangContext = userLangContext;
            this.codeCatalog = codeCatalog;
            this.htmlCleaner = htmlCleaner;
            this.typoOptions = typoOptions;
        }

        public Lang getWorkingLang() {
            return this.userLangContext.getWorkingLang();
        }

        public UserLangContext getUserLangContext() {
            return this.userLangContext;
        }

        public CodeCatalog getCodeCatalog() {
            return this.codeCatalog;
        }

        public HtmlCleaner getHtmlCleaner() {
            return this.htmlCleaner;
        }

        public TypoOptions getTypoOptions() {
            return this.typoOptions;
        }

        public char getItemListSeparateur() {
            return this.itemListSeparateur;
        }

        public void setItemListSeparateur(char itemListSeparateur) {
            this.itemListSeparateur = itemListSeparateur;
        }

        public Redacteur getUserRedacteur() {
            return this.userRedacteur;
        }

        public void setUserRedacteur(Redacteur userRedacteur) {
            this.userRedacteur = userRedacteur;
        }
    }

    private class SubfieldBuffer {
        private final CorpusField corpusField;
        private final Map<SubfieldKey, String> subfieldMap = new LinkedHashMap<SubfieldKey, String>();

        private SubfieldBuffer(CorpusField corpusField) {
            this.corpusField = corpusField;
        }

        private void putSubfield(SubfieldKey subfieldKey, String value) {
            this.subfieldMap.put(subfieldKey, value);
        }

        private void flush() {
            switch (this.corpusField.getFicheItemType()) {
                case "amount": {
                    if (this.corpusField.isProp()) {
                        this.flushAmountProp();
                        break;
                    }
                    this.flushAmountInfo();
                    break;
                }
                case "person": {
                    this.flushPerson();
                    break;
                }
                case "geopoint": {
                    this.flushGeopoint();
                    break;
                }
                case "image": {
                    this.flushImage();
                }
            }
        }

        private void flushAmountProp() {
            String num = "";
            String cur = "";
            for (Map.Entry<SubfieldKey, String> entry : this.subfieldMap.entrySet()) {
                String value = entry.getValue();
                switch (entry.getKey().getSubtype()) {
                    case "currency": {
                        cur = value;
                        break;
                    }
                    case "value": {
                        num = value;
                    }
                }
            }
            FicheParser.this.parseAmountProp(this.corpusField, num, cur);
        }

        private void flushAmountInfo() {
            HashSet<ExtendedCurrency> currencySet = new HashSet<ExtendedCurrency>();
            ArrayList<FicheItem> ficheItemCollection = new ArrayList<FicheItem>();
            String othersValue = null;
            block8: for (Map.Entry<SubfieldKey, String> entry : this.subfieldMap.entrySet()) {
                String value = entry.getValue();
                SubfieldKey subfieldKey = entry.getKey();
                switch (entry.getKey().getSubtype()) {
                    case "amount": {
                        FicheItem ficheItem = FicheParser.this.parseAmountInfoSubfield(this.corpusField, ((AmountSubfieldKey)subfieldKey).getCurrency(), value);
                        if (ficheItem == null) break;
                        if (ficheItem instanceof AmountItem) {
                            AmountItem amountItem = (AmountItem)ficheItem;
                            if (currencySet.contains(amountItem.getCurrency())) continue block8;
                            ficheItemCollection.add(amountItem);
                            currencySet.add(amountItem.getCurrency());
                            break;
                        }
                        ficheItemCollection.add(ficheItem);
                        break;
                    }
                    case "others": {
                        othersValue = value;
                    }
                }
            }
            if (othersValue != null) {
                String[] tokens = StringUtils.getTechnicalTokens(othersValue, FicheParser.this.parameters.getItemListSeparateur(), false);
                int length = tokens.length;
                for (int i = 0; i < length; ++i) {
                    FicheItem ficheItem = FicheParser.this.parseFicheItem(tokens[i], this.corpusField);
                    if (ficheItem == null) continue;
                    if (ficheItem instanceof AmountItem) {
                        AmountItem amountItem = (AmountItem)ficheItem;
                        if (currencySet.contains(amountItem.getCurrency())) continue;
                        ficheItemCollection.add(amountItem);
                        currencySet.add(amountItem.getCurrency());
                        continue;
                    }
                    ficheItemCollection.add(ficheItem);
                }
            }
            FicheParser.this.addInInfo(this.corpusField, FicheUtils.toFicheItems(ficheItemCollection));
        }

        private void flushGeopoint() {
            String latitude = "";
            String longitude = "";
            for (Map.Entry<SubfieldKey, String> entry : this.subfieldMap.entrySet()) {
                String value = entry.getValue();
                switch (entry.getKey().getSubtype()) {
                    case "lat": {
                        latitude = value;
                        break;
                    }
                    case "lon": {
                        longitude = value;
                    }
                }
            }
            FicheParser.this.parseGeopointProp(this.corpusField, latitude, longitude);
        }

        private void flushPerson() {
            String surname = "";
            String forename = "";
            String nonlatin = "";
            String surnameFirstString = "";
            for (Map.Entry<SubfieldKey, String> entry : this.subfieldMap.entrySet()) {
                String value = entry.getValue();
                switch (entry.getKey().getSubtype()) {
                    case "surname": {
                        surname = value;
                        break;
                    }
                    case "forename": {
                        forename = value;
                        break;
                    }
                    case "nonlatin": {
                        nonlatin = value;
                        break;
                    }
                    case "surnamefirst": {
                        surnameFirstString = value;
                    }
                }
            }
            FicheParser.this.parsePersonProp(this.corpusField, surname, forename, nonlatin, surnameFirstString);
        }

        private void flushImage() {
            String src = "";
            String alt = "";
            String title = "";
            for (Map.Entry<SubfieldKey, String> entry : this.subfieldMap.entrySet()) {
                String value = entry.getValue();
                switch (entry.getKey().getSubtype()) {
                    case "src": {
                        src = value;
                        break;
                    }
                    case "alt": {
                        alt = value;
                        break;
                    }
                    case "title": {
                        title = value;
                    }
                }
            }
            FicheParser.this.parseImageProp(this.corpusField, src, alt, title);
        }
    }
}

