/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.from.html;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fichotheque.corpus.fiche.S;
import net.fichotheque.tools.from.html.ContentBuffer;
import net.fichotheque.tools.from.html.TagUtils;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

public final class InlineConversion {
    private InlineConversion() {
    }

    public static boolean canConvert(Element element) {
        switch (element.tagName()) {
            case "a": 
            case "abbr": 
            case "b": 
            case "br": 
            case "cite": 
            case "code": 
            case "del": 
            case "dfn": 
            case "em": 
            case "font": 
            case "i": 
            case "img": 
            case "ins": 
            case "kbd": 
            case "q": 
            case "samp": 
            case "span": 
            case "strong": 
            case "sub": 
            case "sup": 
            case "u": 
            case "var": {
                return true;
            }
        }
        return false;
    }

    public static void convertInto(Element inlineElement, ContentBuffer contentBuffer) {
        S fromBdfAttributeS = InlineConversion.convertFromBdfAttributes(inlineElement);
        if (fromBdfAttributeS != null) {
            InlineConversion.appendTo(fromBdfAttributeS, contentBuffer, inlineElement);
            return;
        }
        if (InlineConversion.isIgnorable(inlineElement)) {
            contentBuffer.add(inlineElement.childNodes());
            return;
        }
        if (InlineConversion.isSplitable(inlineElement)) {
            contentBuffer.add(InlineConversion.split(inlineElement));
            return;
        }
        S s = InlineConversion.convert(inlineElement);
        InlineConversion.appendTo(s, contentBuffer, inlineElement);
    }

    private static void appendTo(S s, ContentBuffer contentBuffer, Element originElement) {
        String wholeText = originElement.wholeText();
        int wholeTextLength = wholeText.length();
        if (wholeTextLength > 0 && Character.isWhitespace(wholeText.charAt(0))) {
            contentBuffer.addPart(" ");
        }
        if (s != null) {
            contentBuffer.addPart(s);
        } else {
            contentBuffer.addPart(originElement.text());
        }
        if (wholeTextLength > 0 && Character.isWhitespace(wholeText.charAt(wholeTextLength - 1))) {
            contentBuffer.addPart(" ");
        }
    }

    private static S convertFromBdfAttributes(Element element) {
        short type;
        Map dataset = element.dataset();
        String bdfType = (String)dataset.get("bdf-type");
        if (bdfType == null) {
            return null;
        }
        try {
            type = S.typeToShort(bdfType);
        }
        catch (IllegalArgumentException iae) {
            type = 16;
        }
        S fromBdfAttributeS = new S(type);
        fromBdfAttributeS.setValue(element.text());
        String bdfRef = (String)dataset.get("bdf-ref");
        if (bdfRef != null) {
            fromBdfAttributeS.setRef(bdfRef);
        }
        return fromBdfAttributeS;
    }

    private static boolean isIgnorable(Element element) {
        switch (element.tagName()) {
            case "font": 
            case "span": {
                return true;
            }
        }
        return false;
    }

    private static boolean isSplitable(Element element) {
        switch (element.tagName()) {
            case "i": 
            case "u": 
            case "em": 
            case "b": 
            case "strong": {
                return element.childNodeSize() > 1;
            }
        }
        return false;
    }

    private static List<Node> split(Element element) {
        String wrap = "<" + element.tagName() + "></" + element.tagName() + ">";
        ArrayList<Node> result = new ArrayList<Node>();
        for (Node node : element.childNodes()) {
            result.add(node.wrap(wrap).parent());
        }
        return result;
    }

    private static S convert(Element element) {
        switch (element.tagName()) {
            case "a": {
                return InlineConversion.convertLink(element);
            }
            case "b": 
            case "strong": {
                return InlineConversion.convertStrg(element);
            }
            case "i": 
            case "u": 
            case "em": {
                return InlineConversion.convertEm(element);
            }
            case "img": {
                return InlineConversion.convertImage(element, null);
            }
            case "abbr": {
                return new S(14);
            }
            case "br": {
                return new S(20);
            }
            case "cite": {
                return InlineConversion.convert((short)9, element);
            }
            case "code": {
                return InlineConversion.convert((short)18, element);
            }
            case "del": {
                return InlineConversion.convert((short)17, element);
            }
            case "dfn": {
                return InlineConversion.convert((short)10, element);
            }
            case "ins": {
                return InlineConversion.convert((short)19, element);
            }
            case "kbd": {
                return InlineConversion.convert((short)12, element);
            }
            case "q": {
                return InlineConversion.convert((short)23, element);
            }
            case "samp": {
                return InlineConversion.convert((short)11, element);
            }
            case "sub": {
                return InlineConversion.convert((short)22, element);
            }
            case "sup": {
                return InlineConversion.convert((short)21, element);
            }
            case "var": {
                return InlineConversion.convert((short)13, element);
            }
        }
        return null;
    }

    private static S convert(short type, Element element) {
        return InlineConversion.toS(type, element, InlineConversion.getRefElement(element));
    }

    private static S convertImage(Element element, Element linkElement) {
        S span = new S(7);
        span.setRef(element.attr("src"));
        InlineConversion.addTitle(span, element, linkElement);
        span.setValue(element.attr("alt"));
        if (linkElement != null) {
            InlineConversion.addLinkAttributes(linkElement, span);
            InlineConversion.addAttribute(linkElement, span, "href");
        }
        return span;
    }

    private static S convertLink(Element element) {
        short type = 3;
        Element loneChild = TagUtils.getLoneChild(element);
        if (loneChild != null) {
            if (loneChild.tagName().equals("img")) {
                return InlineConversion.convertImage(loneChild, element);
            }
            type = InlineConversion.checkEmStrg(type, loneChild);
        }
        return InlineConversion.toS(type, element, element);
    }

    private static S convertStrg(Element element) {
        Element loneChild = TagUtils.getLoneChild(element);
        short type = 2;
        Element refChild = null;
        if (loneChild != null) {
            refChild = InlineConversion.getRefElement(loneChild);
            type = InlineConversion.checkEmStrg(type, loneChild);
        }
        return InlineConversion.toS(type, element, refChild);
    }

    private static S convertEm(Element element) {
        Element loneChild = TagUtils.getLoneChild(element);
        short type = 1;
        Element refChild = null;
        if (loneChild != null) {
            refChild = InlineConversion.getRefElement(loneChild);
            type = InlineConversion.checkEmStrg(type, loneChild);
        }
        if (element.hasClass("STRG")) {
            type = 4;
        }
        return InlineConversion.toS(type, element, refChild);
    }

    private static S toS(short type, Element mainElement, Element refElement) {
        S span = new S(type);
        if (refElement != null) {
            span.setRef(refElement.attr("href"));
            InlineConversion.addLinkAttributes(refElement, span);
        }
        InlineConversion.addTitle(span, mainElement, refElement);
        span.setValue(mainElement.text());
        return span;
    }

    private static void addTitle(S s, Element firstElement, Element secondElement) {
        String title = firstElement.attr("title");
        if (title.isEmpty() && secondElement != null) {
            title = secondElement.attr("title");
        }
        if (!title.isEmpty()) {
            s.putAtt("title", title);
        }
    }

    private static Element getRefElement(Element element) {
        if (element.tagName().equals("a")) {
            return element;
        }
        Element loneChild = TagUtils.getLoneChild(element);
        if (loneChild != null) {
            return InlineConversion.getRefElement(loneChild);
        }
        return null;
    }

    private static short checkEmStrg(short type, Element element) {
        switch (element.tagName()) {
            case "b": 
            case "strong": {
                if (type == 1) {
                    type = (short)4;
                    break;
                }
                type = (short)2;
                break;
            }
            case "i": 
            case "u": 
            case "em": {
                type = type == 2 ? (short)4 : (short)1;
            }
        }
        if (type == 4) {
            return type;
        }
        Element loneChild = TagUtils.getLoneChild(element);
        if (loneChild != null) {
            type = InlineConversion.checkEmStrg(type, loneChild);
        }
        return type;
    }

    private static void addLinkAttributes(Element linkElement, S span) {
        InlineConversion.addAttribute(linkElement, span, "hreflang");
        InlineConversion.addAttribute(linkElement, span, "rel");
        InlineConversion.addAttribute(linkElement, span, "target");
        InlineConversion.addAttribute(linkElement, span, "name");
    }

    private static void addAttribute(Element element, S span, String name) {
        String value = element.attr(name);
        if (!value.isEmpty()) {
            span.putAtt(name, value);
        }
    }
}

