/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.tokenizers.subfield;

import net.fichotheque.Fichotheque;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.SubfieldKey;
import net.fichotheque.format.Tokenizer;
import net.fichotheque.format.formatters.SubfieldFormatter;
import net.fichotheque.tools.format.tokenizers.subfield.AmountInfoTokenizer;
import net.fichotheque.tools.format.tokenizers.subfield.AmountPropTokenizer;
import net.fichotheque.tools.format.tokenizers.subfield.GeopointInfoTokenizer;
import net.fichotheque.tools.format.tokenizers.subfield.ImagePropTokenizer;
import net.fichotheque.tools.format.tokenizers.subfield.PersonPropTokenizer;
import net.mapeadores.util.exceptions.SwitchException;

public class SubfieldTokenizerFactory {
    private SubfieldTokenizerFactory() {
    }

    public static Tokenizer newInstance(CorpusField corpusField, SubfieldKey subfieldKey, SubfieldFormatter subfieldFormatter, Fichotheque fichotheque) {
        switch (subfieldKey.getSubtype()) {
            case "surname": 
            case "forename": 
            case "nonlatin": 
            case "surnamefirst": {
                return new PersonPropTokenizer(subfieldKey, subfieldFormatter, fichotheque);
            }
            case "src": 
            case "alt": 
            case "title": {
                return new ImagePropTokenizer(subfieldKey, subfieldFormatter);
            }
            case "currency": 
            case "value": {
                return new AmountPropTokenizer(subfieldKey, subfieldFormatter);
            }
            case "lat": 
            case "lon": {
                return new GeopointInfoTokenizer(subfieldKey, subfieldFormatter);
            }
            case "others": 
            case "amount": {
                return new AmountInfoTokenizer(corpusField, subfieldKey, subfieldFormatter);
            }
        }
        throw new SwitchException("subfieldType = " + subfieldKey.getSubtype());
    }
}

