/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.posttransform;

import javax.xml.transform.TransformerException;
import net.mapeadores.util.text.StringCleaner;
import net.mapeadores.util.text.UriStringCleaner;
import net.mapeadores.util.xml.json.XmlToJson;

public abstract class Posttransformer {
    public static final String URI_CLEAN_NAME = "uri_clean";
    public static final String URI_ENCODE_NAME = "uri_encode";
    private static final Posttransformer JSONSTRUCTURE = new JsonStructurePosttransformer();
    private static final Posttransformer JSONML = new JsonMLPosttransformer();
    private static final Posttransformer URI_CLEAN = new CleanerPosttransformer(new UriStringCleaner(false));
    private static final Posttransformer URI_ENCODE = new CleanerPosttransformer(new UriStringCleaner(true));

    public abstract String posttransform(String var1);

    public static Posttransformer getPosttransformer(String posttransform) {
        if (posttransform == null) {
            return null;
        }
        if (posttransform.length() == 0) {
            return null;
        }
        switch (posttransform) {
            case "jsonstructure": {
                return JSONSTRUCTURE;
            }
            case "jsonml": {
                return JSONML;
            }
            case "uri_clean": {
                return URI_CLEAN;
            }
            case "uri_encode": {
                return URI_ENCODE;
            }
        }
        return new UnknownErrorPosttransformer(posttransform);
    }

    private static class UnknownErrorPosttransformer
    extends Posttransformer {
        private final String posttransform;

        private UnknownErrorPosttransformer(String posttransform) {
            this.posttransform = posttransform;
        }

        @Override
        public String posttransform(String result) {
            return "#POSTTRANSFORM UNKNOWN: " + this.posttransform;
        }
    }

    private static class JsonStructurePosttransformer
    extends Posttransformer {
        private JsonStructurePosttransformer() {
        }

        @Override
        public String posttransform(String result) {
            if (result == null) {
                return null;
            }
            if ((result = result.trim()).length() == 0) {
                return null;
            }
            try {
                return XmlToJson.transform("jsonstructure", result);
            }
            catch (TransformerException te) {
                Throwable th = te.getCause();
                String message = th != null ? th.getMessage() : te.getMessage();
                return "#TRANSFORM ERROR: " + message;
            }
        }
    }

    private static class JsonMLPosttransformer
    extends Posttransformer {
        private JsonMLPosttransformer() {
        }

        @Override
        public String posttransform(String result) {
            if (result == null) {
                return null;
            }
            if ((result = result.trim()).length() == 0) {
                return null;
            }
            try {
                return XmlToJson.transform("jsonml", result);
            }
            catch (TransformerException te) {
                Throwable th = te.getCause();
                String message = th != null ? th.getMessage() : te.getMessage();
                return "#TRANSFORM ERROR: " + message;
            }
        }
    }

    private static class CleanerPosttransformer
    extends Posttransformer {
        private final StringCleaner cleaner;

        private CleanerPosttransformer(StringCleaner cleaner) {
            this.cleaner = cleaner;
        }

        @Override
        public String posttransform(String result) {
            return this.cleaner.clean(result);
        }
    }
}

