/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.formatters;

import net.mapeadores.util.instruction.Argument;
import net.mapeadores.util.instruction.Instruction;

public class ValuesParameters {
    private final String separator;
    private final int startIndex;
    private final int limit;

    public ValuesParameters(String separator, int startIndex, int limit) {
        this.separator = separator;
        this.startIndex = startIndex;
        this.limit = limit;
    }

    public String getSeparator() {
        return this.separator;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getLimit() {
        return this.limit;
    }

    public static ValuesParameters fromInstruction(Instruction instruction) {
        String separator = "\n";
        int startIndex = 0;
        int limit = -1;
        for (Argument argument : instruction) {
            String key = argument.getKey();
            if (key.equals("sep")) {
                separator = argument.getValue();
                continue;
            }
            if (key.equals("start")) {
                try {
                    int val = Integer.parseInt(argument.getValue());
                    if (val <= 0) continue;
                    startIndex = val - 1;
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (!key.equals("limit")) continue;
            try {
                limit = Integer.parseInt(argument.getValue());
                if (limit >= 1) continue;
                limit = -1;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return new ValuesParameters(separator, startIndex, limit);
    }
}

