/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.formatters;

import java.text.ParseException;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import net.fichotheque.format.FormatSource;
import net.mapeadores.util.instruction.Argument;
import net.mapeadores.util.instruction.Instruction;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LangContext;
import net.mapeadores.util.localisation.ListLangContext;
import net.mapeadores.util.localisation.ListLangContextBuilder;
import net.mapeadores.util.localisation.UserLangContext;
import net.mapeadores.util.text.StringUtils;

public class LangParameters {
    private final ListLangContext customLangContext;
    private final String separator;

    private LangParameters(ListLangContext customLangContext, String separator) {
        this.customLangContext = customLangContext;
        this.separator = separator;
    }

    public ListLangContext getCustomLangContext() {
        return this.customLangContext;
    }

    public String getSeparator() {
        if (this.separator == null) {
            return ", ";
        }
        return this.separator;
    }

    public static LangParameters fromInstruction(Instruction instruction, String langKey) {
        ListLangContext customLangContext = null;
        Lang[] langArray = LangParameters.toLangArray(instruction, langKey);
        if (langArray != null) {
            customLangContext = ListLangContextBuilder.build(langArray);
        }
        String separator = null;
        for (Argument argument : instruction) {
            String key = argument.getKey();
            if (!key.equals("sep")) continue;
            separator = argument.getValue();
        }
        return new LangParameters(customLangContext, separator);
    }

    private static Lang[] toLangArray(Instruction instruction, String langKey) {
        LinkedHashSet<Lang> set = new LinkedHashSet<Lang>();
        for (Argument argument : instruction) {
            String[] tokens;
            String value;
            if (!argument.getKey().equals(langKey) || (value = argument.getValue()) == null) continue;
            for (String token : tokens = StringUtils.getTechnicalTokens(value, true)) {
                LangParameters.addLang(set, token);
            }
        }
        int size = set.size();
        if (size > 0) {
            return set.toArray(new Lang[size]);
        }
        return null;
    }

    private static void addLang(Set<Lang> set, String value) {
        if (value == null || value.length() == 0) {
            return;
        }
        try {
            Lang lang = Lang.parse(value);
            set.add(lang);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public static Locale[] checkLocaleArray(LangParameters langParameters, FormatSource formatSource) {
        Locale[] result;
        LangContext langContext = langParameters.getCustomLangContext();
        if (langContext == null) {
            langContext = formatSource.getLangContext();
        }
        if (langContext instanceof ListLangContext) {
            LangContext listLangContext = langContext;
            int langSize = listLangContext.size();
            result = new Locale[langSize];
            for (int i = 0; i < langSize; ++i) {
                result[i] = ((ListLangContext.Unit)listLangContext.get(i)).getFormatLocale();
            }
        } else if (langContext instanceof UserLangContext) {
            result = new Locale[1];
            UserLangContext userLangContext = (UserLangContext)langContext;
            result[0] = userLangContext.getFormatLocale();
        } else {
            result = new Locale[]{};
        }
        return result;
    }

    public static Lang[] checkLangArray(LangParameters langParameters, FormatSource formatSource) {
        Lang[] result;
        LangContext langContext = langParameters.getCustomLangContext();
        if (langContext == null) {
            langContext = formatSource.getLangContext();
        }
        if (langContext instanceof ListLangContext) {
            LangContext listLangContext = langContext;
            int langSize = listLangContext.size();
            result = new Lang[langSize];
            for (int i = 0; i < langSize; ++i) {
                result[i] = ((ListLangContext.Unit)listLangContext.get(i)).getLang();
            }
        } else if (langContext instanceof UserLangContext) {
            result = new Lang[1];
            UserLangContext userLangContext = (UserLangContext)langContext;
            result[0] = userLangContext.getWorkingLang();
        } else {
            result = new Lang[]{};
        }
        return result;
    }
}

