/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.formatters;

import java.io.IOException;
import java.util.List;
import net.fichotheque.addenda.Document;
import net.fichotheque.addenda.Version;
import net.fichotheque.format.FormatContext;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.formatters.DocumentFormatter;
import net.fichotheque.json.DocumentJson;
import net.fichotheque.tools.format.formatters.JsonParameters;
import net.fichotheque.tools.format.formatters.LangParameters;
import net.fichotheque.tools.format.patterndefs.DefaultPattern;
import net.fichotheque.utils.FormatterUtils;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.instruction.Argument;
import net.mapeadores.util.instruction.Instruction;
import net.mapeadores.util.instruction.InstructionResolver;
import net.mapeadores.util.instruction.InstructionResolverProvider;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.localisation.LangContext;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.logging.MessageHandler;

public final class DocumentFormatterParser {
    private static final DocumentFormatter ADDENDA_PART = (document, weight, formatSource) -> document.getSubsetName();
    private static final DocumentFormatter BASENAME_PART = (document, weight, formatSource) -> document.getBasename();
    private static final DocumentFormatter EXTENSIONS_PART = (document, weight, formatSource) -> {
        List<Version> versionList = document.getVersionList();
        if (versionList.size() == 1) {
            return '.' + versionList.get(0).getExtension();
        }
        StringBuilder buf = new StringBuilder();
        for (Version version : versionList) {
            buf.append('[');
            buf.append('.');
            buf.append(version.getExtension());
            buf.append(']');
        }
        return buf.toString();
    };
    private static final DocumentFormatter ID_PART = (document, weight, formatSource) -> String.valueOf(document.getId());
    private static final DocumentFormatter WEIGHT_PART = (document, weight, formatSource) -> String.valueOf(weight);
    private static final DocumentFormatter WITHWEIGHTFILTER_FORMSYNTAX_PART = new FormSyntaxPart(true);
    private static final DocumentFormatter WITHOUTWEIGHTFILTER_FORMSYNTAX_PART = new FormSyntaxPart(false);
    private static final JsonParameters DEFAULT_JSONPARAMETERS = JsonParameters.parse("basename,versions,size");

    private DocumentFormatterParser() {
    }

    public static DocumentFormatter parse(String pattern, FormatContext formatContext, boolean withWeightFilter, MessageHandler messageHandler) {
        if (pattern == null) {
            pattern = DefaultPattern.document();
        }
        try {
            return DocumentFormatterParser.parse(pattern, formatContext, withWeightFilter);
        }
        catch (ErrorMessageException fe) {
            messageHandler.addMessage("severe.format.pattern", fe.getErrorMessage());
            return null;
        }
    }

    public static DocumentFormatter parse(String pattern, FormatContext formatContext, boolean withWeightFilter) throws ErrorMessageException {
        Object[] partArray = FormatterUtils.parsePattern(new InternalInstructionResolver(formatContext, withWeightFilter), pattern);
        return new InternalDocumentFormatter(partArray);
    }

    private static class InternalInstructionResolver
    implements InstructionResolver {
        private final InstructionResolverProvider provider;
        private final boolean withWeightFilter;

        private InternalInstructionResolver(FormatContext formatContext, boolean withWeightFilter) {
            this.provider = formatContext.getInstructionResolverProvider();
            this.withWeightFilter = withWeightFilter;
        }

        @Override
        public Object resolve(Instruction instruction) throws ErrorMessageException {
            String key;
            Object formatter;
            InstructionResolver resolver = this.provider.getInstructionResolver(DocumentFormatter.class);
            if (resolver != null && (formatter = resolver.resolve(instruction)) != null) {
                return formatter;
            }
            Argument arg1 = (Argument)instruction.get(0);
            switch (key = arg1.getKey()) {
                case "addenda": {
                    return ADDENDA_PART;
                }
                case "basename": {
                    return BASENAME_PART;
                }
                case "extensions": {
                    return EXTENSIONS_PART;
                }
                case "formsyntax": {
                    if (this.withWeightFilter) {
                        return WITHWEIGHTFILTER_FORMSYNTAX_PART;
                    }
                    return WITHOUTWEIGHTFILTER_FORMSYNTAX_PART;
                }
                case "id": {
                    return ID_PART;
                }
                case "json": {
                    JsonParameters jsonParameters = JsonParameters.fromInstruction(instruction);
                    if (jsonParameters == null) {
                        jsonParameters = DEFAULT_JSONPARAMETERS;
                    }
                    LangParameters langParameters = LangParameters.fromInstruction(instruction, "langs");
                    return new JsonPart(jsonParameters, langParameters.getCustomLangContext());
                }
                case "weight": 
                case "poids": {
                    return WEIGHT_PART;
                }
            }
            return null;
        }
    }

    private static class InternalDocumentFormatter
    implements DocumentFormatter {
        private final Object[] partArray;

        private InternalDocumentFormatter(Object[] partArray) {
            this.partArray = partArray;
        }

        @Override
        public String formatDocument(Document document, int weight, FormatSource formatSource) {
            StringBuilder buf = new StringBuilder();
            for (Object obj : this.partArray) {
                if (obj instanceof String) {
                    buf.append((String)obj);
                    continue;
                }
                DocumentFormatter formatter = (DocumentFormatter)obj;
                buf.append(formatter.formatDocument(document, weight, formatSource));
            }
            return buf.toString();
        }
    }

    private static class FormSyntaxPart
    implements DocumentFormatter {
        private final boolean withWeightFilter;

        private FormSyntaxPart(boolean withWeightFilter) {
            this.withWeightFilter = withWeightFilter;
        }

        @Override
        public String formatDocument(Document document, int weight, FormatSource formatSource) {
            if (this.withWeightFilter || weight == 1) {
                return String.valueOf(document.getId());
            }
            StringBuilder buf = new StringBuilder();
            buf.append(String.valueOf(document.getId()));
            buf.append(" <");
            buf.append(weight);
            buf.append(">");
            return buf.toString();
        }
    }

    private static class JsonPart
    implements DocumentFormatter {
        private final JsonParameters jsonParameters;
        private final LangContext customLangContext;

        private JsonPart(JsonParameters jsonParameters, LangContext customLangContext) {
            this.jsonParameters = jsonParameters;
            this.customLangContext = customLangContext;
        }

        @Override
        public String formatDocument(Document document, int weight, FormatSource formatSource) {
            LangContext langContext = this.customLangContext != null ? this.customLangContext : formatSource.getLangContext();
            StringBuilder buf = new StringBuilder();
            JSONWriter jsonWriter = new JSONWriter(buf);
            try {
                jsonWriter.object();
                DocumentJson.properties(jsonWriter, document, langContext, this.jsonParameters);
                jsonWriter.endObject();
            }
            catch (IOException ioe) {
                throw new ShouldNotOccurException(ioe);
            }
            return buf.toString();
        }
    }
}

