/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.extraction.builders;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fichotheque.extraction.ExtractionConstants;
import net.fichotheque.extraction.def.MotcleFilter;
import net.fichotheque.extraction.def.TagNameInfo;
import net.fichotheque.extraction.def.ThesaurusExtractDef;
import net.fichotheque.selection.MotcleCondition;
import net.fichotheque.utils.SelectionUtils;

public class ThesaurusExtractDefBuilder
implements ExtractionConstants {
    private final Map<String, Boolean> booleanMap = new HashMap<String, Boolean>();
    private MotcleFilter motcleFilter;
    private String name = null;
    private TagNameInfo tagNameInfo = TagNameInfo.DEFAULT;
    private List<MotcleCondition.Entry> entryList = SelectionUtils.EMPTY_MOTCLECONDITIONENTRYLIST;

    public ThesaurusExtractDefBuilder() {
    }

    public ThesaurusExtractDefBuilder(MotcleFilter motcleFilter) {
        if (motcleFilter == null) {
            throw new IllegalArgumentException("motcleFilter is null");
        }
        this.motcleFilter = motcleFilter;
    }

    public ThesaurusExtractDefBuilder setMotcleFilter(MotcleFilter motcleFilter) {
        if (motcleFilter == null) {
            throw new IllegalArgumentException("motcleFilter is null");
        }
        this.motcleFilter = motcleFilter;
        return this;
    }

    public ThesaurusExtractDefBuilder setName(String name) {
        if (name != null && name.length() == 0) {
            name = null;
        }
        this.name = name;
        return this;
    }

    public ThesaurusExtractDefBuilder setTagNameInfo(TagNameInfo tagNameInfo) {
        this.tagNameInfo = tagNameInfo;
        return this;
    }

    public ThesaurusExtractDefBuilder setEntryList(List<MotcleCondition.Entry> list) {
        this.entryList = list;
        return this;
    }

    public ThesaurusExtractDefBuilder setEntryList(MotcleCondition.Entry entry) {
        this.entryList = Collections.singletonList(entry);
        return this;
    }

    public ThesaurusExtractDefBuilder setBoolean(String name, boolean value) {
        if (value) {
            this.booleanMap.put(name, Boolean.TRUE);
        } else {
            this.booleanMap.remove(name);
        }
        return this;
    }

    public ThesaurusExtractDef toThesaurusExtractDef() {
        if (this.motcleFilter == null) {
            throw new IllegalStateException("motcleFilter is null");
        }
        HashMap<String, Boolean> finalBooleanMap = new HashMap<String, Boolean>(this.booleanMap);
        return new InternalThesaurusExtractDef(this.motcleFilter, this.name, this.tagNameInfo, this.entryList, finalBooleanMap);
    }

    public static ThesaurusExtractDefBuilder init() {
        return new ThesaurusExtractDefBuilder();
    }

    public static ThesaurusExtractDefBuilder init(MotcleFilter motcleFilter) {
        return new ThesaurusExtractDefBuilder(motcleFilter);
    }

    private static class InternalThesaurusExtractDef
    implements ThesaurusExtractDef {
        private final MotcleFilter motcleFilter;
        private final String name;
        private final TagNameInfo tagNameInfo;
        private final List<MotcleCondition.Entry> entryList;
        private final Map<String, Boolean> booleanMap;

        private InternalThesaurusExtractDef(MotcleFilter motcleFilter, String name, TagNameInfo tagNameInfo, List<MotcleCondition.Entry> entryList, Map<String, Boolean> booleanMap) {
            this.motcleFilter = motcleFilter;
            this.name = name;
            this.tagNameInfo = tagNameInfo;
            this.entryList = entryList;
            this.booleanMap = booleanMap;
        }

        @Override
        public TagNameInfo getTagNameInfo() {
            return this.tagNameInfo;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public MotcleFilter getMotcleFilter() {
            return this.motcleFilter;
        }

        @Override
        public List<MotcleCondition.Entry> getConditionEntryList() {
            return this.entryList;
        }

        @Override
        public boolean hasBooleanParameters() {
            return !this.booleanMap.isEmpty();
        }

        @Override
        public boolean getBooleanParameter(String name) {
            return this.booleanMap.containsKey(name);
        }
    }
}

