/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.duplication;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fichotheque.ExistingIdException;
import net.fichotheque.Subset;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.NoMasterIdException;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.tools.duplication.DuplicationFilter;
import net.mapeadores.util.text.StringUtils;

public class DuplicationParameters {
    public static final short ALL_FILTER = 1;
    public static final short ONLY_FICHE_FILTER = 2;
    public static final short CUSTOM_FILTER = 3;
    private final Set<Integer> idSet = new LinkedHashSet<Integer>();
    private final Corpus originCorpus;
    private final Corpus destinationCorpus;
    private final Map<Integer, Entry> entryMap = new LinkedHashMap<Integer, Entry>();
    private final Map<FieldKey, FieldMatching> matchingMap = new LinkedHashMap<FieldKey, FieldMatching>();
    private final Set<Integer> destinationIdSet = new HashSet<Integer>();
    private final Subset destinationMaster;
    private short filterType = 1;
    private DuplicationFilter customFilter;
    private boolean linkToOrigin = false;
    private String linkToOriginMode = "";
    private int linkToOriginWeight = -1;

    public DuplicationParameters(Corpus originCorpus, Corpus destinationCorpus) {
        this.originCorpus = originCorpus;
        this.destinationCorpus = destinationCorpus;
        this.destinationMaster = destinationCorpus.getMasterSubset();
    }

    public Corpus getOriginCorpus() {
        return this.originCorpus;
    }

    public Corpus getDestinationCorpus() {
        return this.destinationCorpus;
    }

    public short getFilterType() {
        return this.filterType;
    }

    public DuplicationParameters setFicheFilter(short filterType, DuplicationFilter customFilter) {
        this.filterType = filterType;
        if (filterType == 3) {
            if (customFilter == null) {
                throw new IllegalArgumentException("Custom filter is null");
            }
            this.customFilter = customFilter;
        } else {
            this.customFilter = null;
        }
        return this;
    }

    public DuplicationParameters setLinkWithOrigin(String mode, int weight) throws ParseException {
        if (mode.length() > 0) {
            StringUtils.checkTechnicalName(mode, false);
        }
        if (weight < 1) {
            weight = 1;
        }
        this.linkToOrigin = true;
        this.linkToOriginMode = mode;
        this.linkToOriginWeight = weight;
        return this;
    }

    public boolean withLinkToOrigin() {
        return this.linkToOrigin;
    }

    public int getLinkToOriginWeight() {
        return this.linkToOriginWeight;
    }

    public String getLinkToOriginMode() {
        return this.linkToOriginMode;
    }

    public DuplicationParameters addFicheMeta(FicheMeta origin) {
        if (this.destinationMaster != null) {
            throw new IllegalStateException("this method cannot be used when destination is a satellite corpus");
        }
        if (!this.entryMap.containsKey(origin.getId())) {
            this.entryMap.put(origin.getId(), new Entry(origin, -1));
        }
        return this;
    }

    public DuplicationParameters addFicheMeta(FicheMeta origin, int destinationId) throws ExistingIdException, NoMasterIdException {
        if (this.entryMap.containsKey(origin.getId())) {
            return this;
        }
        if (destinationId < 1) {
            return this.addFicheMeta(origin);
        }
        if (this.destinationCorpus.getFicheMetaById(destinationId) != null) {
            throw new ExistingIdException();
        }
        if (this.destinationIdSet.contains(destinationId)) {
            throw new ExistingIdException();
        }
        this.destinationIdSet.add(destinationId);
        if (this.destinationMaster != null && this.destinationMaster.getSubsetItemById(destinationId) == null) {
            throw new NoMasterIdException();
        }
        this.entryMap.put(origin.getId(), new Entry(origin, destinationId));
        return this;
    }

    public void addOriginId(int id) {
        if (id < 1) {
            throw new IllegalArgumentException("id < 1");
        }
        if (!this.idSet.contains(id)) {
            this.idSet.add(id);
        }
    }

    public List<Entry> getEntryList() {
        return new ArrayList<Entry>(this.entryMap.values());
    }

    public DuplicationFilter getCustomFilter() {
        return this.customFilter;
    }

    public void addFieldMatching(FieldKey originKey, FieldKey destinationKey) {
        this.matchingMap.put(originKey, new FieldMatching(originKey, destinationKey));
    }

    public List<FieldMatching> getFieldMatchingList() {
        return new ArrayList<FieldMatching>(this.matchingMap.values());
    }

    public static class Entry {
        private final FicheMeta origin;
        private final int destinationId;

        private Entry(FicheMeta origin, int destinationId) {
            this.origin = origin;
            this.destinationId = destinationId;
        }

        public FicheMeta getOrigin() {
            return this.origin;
        }

        public int getDestinationId() {
            return this.destinationId;
        }
    }

    public static class FieldMatching {
        private final FieldKey originKey;
        private final FieldKey destinationKey;

        private FieldMatching(FieldKey originKey, FieldKey destinationKey) {
            this.originKey = originKey;
            this.destinationKey = destinationKey;
        }

        public FieldKey getOriginKey() {
            return this.originKey;
        }

        public FieldKey getDestinationKey() {
            return this.destinationKey;
        }
    }
}

