/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.dom.revisions;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.fichotheque.croisement.CroisementRevision;
import net.fichotheque.croisement.Lien;
import net.fichotheque.utils.CroisementUtils;
import net.mapeadores.util.xml.DOMUtils;
import org.w3c.dom.Element;

public class CroisementRevisionDOMReader {
    private final RootConsumer rootConsumer = new RootConsumer();

    public CroisementRevision readCroisementRevision(Element element) {
        CroisementRevision croisementRevision = new CroisementRevision();
        DOMUtils.readChildren(element, this.rootConsumer);
        this.rootConsumer.flush(croisementRevision);
        return croisementRevision;
    }

    private class RootConsumer
    implements Consumer<Element> {
        private final Map<String, Lien> lienMap = new LinkedHashMap<String, Lien>();
        private final List<Element> attrTempList = new ArrayList<Element>();

        private RootConsumer() {
        }

        private void clear() {
            this.lienMap.clear();
            this.attrTempList.clear();
        }

        private void flush(CroisementRevision croisementRevision) {
            for (Lien lien : this.lienMap.values()) {
                croisementRevision.addLien(lien);
            }
            this.clear();
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("lien")) {
                String mode = element.getAttribute("mode");
                int weight = this.getWeight(element);
                int position1 = this.getPosition(element, "position1");
                int position2 = this.getPosition(element, "position2");
                Lien lien = CroisementUtils.toLien(mode, weight, position1, position2);
                this.lienMap.put(mode, lien);
            } else if (tagName.equals("attr")) {
                this.attrTempList.add(element);
            }
        }

        private int getWeight(Element element) {
            int weight = 1;
            String weightString = element.getAttribute("poids");
            if (weightString.isEmpty()) {
                weightString = element.getAttribute("weight");
            }
            if (weightString.length() > 0) {
                try {
                    weight = Integer.parseInt(weightString);
                    if (weight < 1) {
                        weight = 1;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return weight;
        }

        private int getPosition(Element element, String attributeName) {
            int position = 0;
            String posString = element.getAttribute(attributeName);
            if (posString.length() > 0) {
                try {
                    position = Integer.parseInt(posString);
                    if (position < 0) {
                        position = 0;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return position;
        }
    }
}

