/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.dom;

import java.text.ParseException;
import net.fichotheque.MetadataEditor;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.xml.DomMessages;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class FichothequeDOMUtils {
    private FichothequeDOMUtils() {
    }

    public static void readIntitule(Element element, MetadataEditor metadataEditor, MessageHandler messageHandler, String titleName) {
        String name = element.getAttribute("name");
        if (name.length() == 0) {
            return;
        }
        if (name.equals(titleName)) {
            name = null;
        } else if (name.equals("fiche.existing")) {
            name = "fiche";
        } else if (name.equals("fiche.new")) {
            name = "newfiche";
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node nd = nodeList.item(i);
            if (nd.getNodeType() != 1) continue;
            Element child = (Element)nd;
            String tagname = child.getTagName();
            if (tagname.equals("label") || tagname.equals("lib")) {
                try {
                    Label label = LabelUtils.readLabel(child);
                    if (label == null) continue;
                    metadataEditor.putLabel(name, label);
                }
                catch (ParseException e) {
                    DomMessages.wrongLangAttribute(messageHandler, "intitule[@name=\"" + name + "\"]", child.getAttribute("xml:lang"));
                }
                continue;
            }
            DomMessages.unknownTagWarning(messageHandler, tagname);
        }
    }
}

