/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.dom;

import java.text.ParseException;
import java.util.function.Consumer;
import net.fichotheque.ExistingNameException;
import net.fichotheque.album.metadata.AlbumDim;
import net.fichotheque.album.metadata.AlbumMetadataEditor;
import net.fichotheque.tools.dom.AbstractMetadataDOMReader;
import net.fichotheque.utils.AlbumUtils;
import net.mapeadores.util.attr.AttributesBuilder;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.DomMessages;
import org.w3c.dom.Element;

public class AlbumMetadataDOMReader
extends AbstractMetadataDOMReader {
    private final AlbumMetadataEditor albumMetadataEditor;

    public AlbumMetadataDOMReader(AlbumMetadataEditor albumMetadataEditor, MessageHandler messageHandler) {
        super(albumMetadataEditor, messageHandler, "album");
        this.albumMetadataEditor = albumMetadataEditor;
    }

    public void fillMetadata(Element element) {
        AttributesBuilder attributesBuilder = new AttributesBuilder();
        DOMUtils.readChildren(element, new RootConsumer(attributesBuilder, "/" + element.getTagName()));
        this.flush(attributesBuilder);
    }

    private class RootConsumer
    implements Consumer<Element> {
        private AttributesBuilder attributesBuilder;
        private final String parentXpath;

        private RootConsumer(AttributesBuilder attributesBuilder, String parentXpath) {
            this.attributesBuilder = attributesBuilder;
            this.parentXpath = parentXpath;
        }

        @Override
        public void accept(Element element) {
            if (AlbumMetadataDOMReader.this.readCommonElement(element, this.attributesBuilder, this.parentXpath)) {
                return;
            }
            String tagname = element.getTagName();
            String xpath = this.parentXpath + "/" + tagname;
            if (tagname.equals("album-dim")) {
                this.addAlbumDim(element, xpath);
            } else if (!tagname.equals("dim-usage")) {
                DomMessages.unknownTagWarning(AlbumMetadataDOMReader.this.messageHandler, xpath);
            }
        }

        private void addAlbumDim(Element element, String xpath) {
            AlbumDim albumDim;
            String name = element.getAttribute("name");
            if (name.length() == 0) {
                DomMessages.emptyAttribute(AlbumMetadataDOMReader.this.messageHandler, xpath, "name");
                return;
            }
            xpath = xpath + " name=\"" + name + "\"";
            String type = element.getAttribute("type");
            if (type.isEmpty()) {
                DomMessages.emptyAttribute(AlbumMetadataDOMReader.this.messageHandler, xpath, "type");
                return;
            }
            try {
                type = AlbumUtils.checkDimType(type);
            }
            catch (IllegalArgumentException iae) {
                DomMessages.wrongAttributeValue(AlbumMetadataDOMReader.this.messageHandler, xpath, "type", type);
                return;
            }
            int width = 0;
            int height = 0;
            if (AlbumUtils.needWidth(type) && (width = this.getInt(element, xpath, "width")) == -1) {
                return;
            }
            if (AlbumUtils.needHeight(type) && (height = this.getInt(element, xpath, "height")) == -1) {
                return;
            }
            try {
                albumDim = AlbumMetadataDOMReader.this.albumMetadataEditor.createAlbumDim(name, type);
            }
            catch (ParseException | ExistingNameException e) {
                return;
            }
            AlbumMetadataDOMReader.this.albumMetadataEditor.setDim(albumDim, width, height);
        }

        private int getInt(Element element, String xpath, String attributeName) {
            int result;
            String intString = element.getAttribute(attributeName);
            if (intString.length() == 0) {
                DomMessages.emptyAttribute(AlbumMetadataDOMReader.this.messageHandler, xpath, attributeName);
                return -1;
            }
            try {
                result = Integer.parseInt(intString);
            }
            catch (NumberFormatException nfe) {
                DomMessages.wrongIntegerAttributeValue(AlbumMetadataDOMReader.this.messageHandler, xpath, attributeName, intString);
                return -1;
            }
            if (result < 1) {
                DomMessages.wrongIntegerAttributeValue(AlbumMetadataDOMReader.this.messageHandler, xpath, attributeName, intString);
                return -1;
            }
            return result;
        }
    }
}

