/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.conversion;

import net.fichotheque.corpus.fiche.AmountItem;
import net.fichotheque.corpus.fiche.CountryItem;
import net.fichotheque.corpus.fiche.DateItem;
import net.fichotheque.corpus.fiche.EmailItem;
import net.fichotheque.corpus.fiche.FicheBlock;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.GeopointItem;
import net.fichotheque.corpus.fiche.ImageItem;
import net.fichotheque.corpus.fiche.Item;
import net.fichotheque.corpus.fiche.LanguageItem;
import net.fichotheque.corpus.fiche.LinkItem;
import net.fichotheque.corpus.fiche.NumberItem;
import net.fichotheque.corpus.fiche.P;
import net.fichotheque.corpus.fiche.ParaItem;
import net.fichotheque.corpus.fiche.PersonItem;
import net.fichotheque.corpus.fiche.S;
import net.mapeadores.util.models.EmailCore;

public final class ConversionUtils {
    private ConversionUtils() {
    }

    public static FicheBlock toFicheBlock(FicheItem ficheItem) {
        P prg = new P();
        if (ficheItem instanceof Item) {
            prg.addText(((Item)ficheItem).getValue());
        } else if (ficheItem instanceof ParaItem) {
            for (Object obj : (ParaItem)ficheItem) {
                if (obj instanceof String) {
                    prg.addText((String)obj);
                    continue;
                }
                if (!(obj instanceof S)) continue;
                prg.addS((S)obj);
            }
        } else if (ficheItem instanceof CountryItem) {
            prg.addText(((CountryItem)ficheItem).getCountry().toString());
        } else if (ficheItem instanceof LanguageItem) {
            prg.addText(((LanguageItem)ficheItem).getLang().toString());
        } else if (ficheItem instanceof DateItem) {
            prg.addText(((DateItem)ficheItem).getDate().toISOString());
        } else if (ficheItem instanceof GeopointItem) {
            GeopointItem geopoint = (GeopointItem)ficheItem;
            prg.addText(geopoint.getLatitude().toString() + " " + geopoint.getLongitude().toString());
        } else if (ficheItem instanceof ImageItem) {
            ImageItem image = (ImageItem)ficheItem;
            S span = new S(7);
            span.setRef(image.getSrc());
            span.setValue(image.getAlt());
            prg.addS(span);
        } else if (ficheItem instanceof LinkItem) {
            LinkItem link = (LinkItem)ficheItem;
            S span = new S(3);
            span.setRef(link.getHref());
            span.setValue(link.getTitle());
            prg.addS(span);
        } else if (ficheItem instanceof EmailItem) {
            EmailCore emailCore = ((EmailItem)ficheItem).getEmailCore();
            S span = new S(3);
            span.setRef("mailto:" + emailCore.getAddrSpec());
            span.setValue(emailCore.getRealName());
            prg.addS(span);
        } else if (ficheItem instanceof AmountItem) {
            AmountItem amountItem = (AmountItem)ficheItem;
            prg.addText(amountItem.getCurrency().getCurrencyCode() + " " + amountItem.getDecimal().toString());
        } else if (ficheItem instanceof NumberItem) {
            prg.addText(((NumberItem)ficheItem).getDecimal().toString());
        } else if (ficheItem instanceof PersonItem) {
            PersonItem personItem = (PersonItem)ficheItem;
            String redacteurGlobalId = personItem.getRedacteurGlobalId();
            if (redacteurGlobalId != null) {
                prg.addText(redacteurGlobalId);
            } else {
                prg.addText(personItem.getPersonCore().toStandardStyle());
            }
        } else {
            prg.addText("Unknown : " + ficheItem.getClass().getName());
        }
        return prg;
    }
}

