/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.thesaurus.metadata;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import net.mapeadores.util.localisation.Lang;

public final class ThesaurusFieldKey {
    private static final Map<String, ThesaurusFieldKey> internMap = new HashMap<String, ThesaurusFieldKey>();
    public static final ThesaurusFieldKey ID = new ThesaurusFieldKey("id");
    public static final ThesaurusFieldKey IDALPHA = new ThesaurusFieldKey("idalpha");
    public static final ThesaurusFieldKey PARENT_ID = new ThesaurusFieldKey("parent_id");
    public static final ThesaurusFieldKey PARENT_IDALPHA = new ThesaurusFieldKey("parent_idalpha");
    public static final ThesaurusFieldKey BABELIENLABEL = new ThesaurusFieldKey("label");
    public static final ThesaurusFieldKey BABELIENLANG = new ThesaurusFieldKey("lang");
    public static final ThesaurusFieldKey POSITION_LOCAL = new ThesaurusFieldKey("pos_loc");
    public static final ThesaurusFieldKey POSITION_GLOBAL = new ThesaurusFieldKey("pos_glob");
    public static final ThesaurusFieldKey LEVEL = new ThesaurusFieldKey("level");
    public static final ThesaurusFieldKey THIS = new ThesaurusFieldKey("this");
    public static final ThesaurusFieldKey STATUS = new ThesaurusFieldKey("status");
    public static final short SPECIAL_CATEGORY = 0;
    public static final short LABEL_CATEGORY = 1;
    private final String fieldKeyString;
    private final short category;
    private final Lang lang;

    private ThesaurusFieldKey(String fieldKeyString) {
        this.fieldKeyString = fieldKeyString;
        this.category = 0;
        this.lang = null;
        ThesaurusFieldKey.intern(this);
    }

    private ThesaurusFieldKey(short category, Lang lang) {
        this(ThesaurusFieldKey.toKeyString(category, lang), category, lang);
    }

    private ThesaurusFieldKey(String fieldKeyString, short category, Lang lang) {
        this.fieldKeyString = fieldKeyString;
        this.category = category;
        this.lang = lang;
        ThesaurusFieldKey.intern(this);
    }

    private static String toKeyString(short category, Lang lang) {
        StringBuilder buf = new StringBuilder();
        if (category == 1) {
            buf.append("label_");
        }
        buf.append(lang.toString());
        return buf.toString();
    }

    private static synchronized void intern(ThesaurusFieldKey thesaurusFieldKey) {
        internMap.put(thesaurusFieldKey.fieldKeyString, thesaurusFieldKey);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ThesaurusFieldKey)) {
            return false;
        }
        ThesaurusFieldKey fk = (ThesaurusFieldKey)obj;
        return fk.fieldKeyString.equals(this.fieldKeyString);
    }

    public int hashCode() {
        return this.fieldKeyString.hashCode();
    }

    public String toString() {
        return this.fieldKeyString;
    }

    public boolean isSpecialThesaurusFieldKey() {
        return this.category == 0;
    }

    public boolean isLabelThesaurusFieldKey() {
        return this.category == 1;
    }

    public short getCategory() {
        return this.category;
    }

    public Lang getLang() {
        return this.lang;
    }

    public static ThesaurusFieldKey parse(String s) throws ParseException {
        if (s.equals("idths")) {
            s = "id";
        } else if (s.equals("parent_idths")) {
            s = "parent_id";
        } else if (s.equals("lib")) {
            s = "label";
        }
        ThesaurusFieldKey current = internMap.get(s);
        if (current != null) {
            return current;
        }
        String langString = null;
        if (s.startsWith("lib_")) {
            langString = s.substring(4);
        } else if (s.startsWith("label_")) {
            langString = s.substring(6);
        }
        if (langString != null) {
            try {
                Lang lang = Lang.parse(langString);
                return new ThesaurusFieldKey(1, lang);
            }
            catch (ParseException pe) {
                throw new ParseException("wrong lang :" + langString, 4);
            }
        }
        throw new ParseException("unkown thesaurusfieldkey : " + s, 0);
    }

    public static ThesaurusFieldKey toLabelThesaurusFieldKey(Lang lang) {
        return new ThesaurusFieldKey(1, lang);
    }
}

