/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.corpus.fiche;

import java.io.Serializable;
import net.fichotheque.corpus.fiche.FicheItem;
import net.mapeadores.util.models.EmailCore;
import net.mapeadores.util.models.EmailCoreUtils;

public final class EmailItem
implements FicheItem,
Serializable {
    private static final long serialVersionUID = 5L;
    private InternalEmailCore emailCore;

    public EmailItem(EmailCore emailCore) {
        this.emailCore = new InternalEmailCore(emailCore);
    }

    public EmailItem(EmailItem emailItem, String realName) {
        if (realName == null) {
            realName = "";
        }
        this.emailCore = new InternalEmailCore(emailItem.emailCore.addrSpec, realName);
    }

    public EmailCore getEmailCore() {
        return this.emailCore;
    }

    public String toString() {
        return this.emailCore.toCompleteString();
    }

    public int hashCode() {
        return this.emailCore.getAddrSpec().hashCode() + this.emailCore.getRealName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EmailItem)) {
            return false;
        }
        return EmailCoreUtils.areEqual(((EmailItem)obj).emailCore, this.emailCore);
    }

    private static class InternalEmailCore
    implements EmailCore,
    Serializable {
        private final String addrSpec;
        private final String realName;

        private InternalEmailCore(String addrSpec, String realName) {
            this.addrSpec = addrSpec;
            this.realName = realName;
        }

        private InternalEmailCore(EmailCore emailCore) {
            this.addrSpec = emailCore.getAddrSpec();
            this.realName = emailCore.getRealName();
        }

        @Override
        public String getRealName() {
            return this.realName;
        }

        @Override
        public String getAddrSpec() {
            return this.addrSpec;
        }
    }
}

