/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.runners;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.configuration.PathConfiguration;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import fr.exemole.bdfserver.tools.configuration.ConfigurationUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;
import net.fichotheque.exportation.scrutari.ScrutariExportDef;
import net.fichotheque.exportation.table.TableExportContext;
import net.fichotheque.extraction.ExtractionContext;
import net.fichotheque.tools.exportation.scrutari.ScrutariExportEngine;
import net.fichotheque.tools.permission.PermissionUtils;
import net.mapeadores.util.hook.HookHandler;
import net.mapeadores.util.localisation.LangsUtils;
import net.mapeadores.util.localisation.LocalisationUtils;
import net.scrutari.dataexport.ScrutariInfoUtils;

public final class ScrutariExportRunner {
    public static final String INFO_SUFFIX = ".scrutari-info";
    public static final String DATA_SUFFIX = ".scrutari-data";
    private final BdfServer bdfServer;
    private final ScrutariExportDef scrutariExportDef;
    private final PathConfiguration pathConfiguration;
    private final File destinationDirectory;

    private ScrutariExportRunner(ScrutariExportDef scrutariExportDef, BdfServer bdfServer, PathConfiguration pathConfiguration) {
        this.scrutariExportDef = scrutariExportDef;
        this.bdfServer = bdfServer;
        this.pathConfiguration = pathConfiguration;
        this.destinationDirectory = ConfigurationUtils.getTarget(pathConfiguration, scrutariExportDef).getFile();
    }

    public static void run(ScrutariExportDef scrutariExportDef, BdfServer bdfServer, PathConfiguration pathConfiguration) throws IOException {
        ScrutariExportRunner runner = new ScrutariExportRunner(scrutariExportDef, bdfServer, pathConfiguration);
        runner.run();
    }

    private void run() throws IOException {
        this.writeInfo();
        this.writeData();
    }

    private void writeInfo() throws IOException {
        File file = new File(this.destinationDirectory, this.scrutariExportDef.getName() + INFO_SUFFIX + ".xml");
        try (BufferedWriter bufwriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));){
            String[] urlArray = new String[]{this.scrutariExportDef.getName() + DATA_SUFFIX + ".xml"};
            ScrutariInfoUtils.writeScrutariInfo(bufwriter, 0, true, new Date(), urlArray);
        }
    }

    private void writeData() throws IOException {
        File file = new File(this.destinationDirectory, this.scrutariExportDef.getName() + DATA_SUFFIX + ".xml");
        ExtractionContext extractionContext = BdfServerUtils.initExtractionContextBuilder(this.bdfServer, LocalisationUtils.toUserLangContext(this.bdfServer.getDefaultWorkingLang()), PermissionUtils.FICHOTHEQUEADMIN_PERMISSIONSUMMARY).toExtractionContext();
        try (BufferedWriter bufwriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));){
            TableExportContext tableExportContext = this.bdfServer.getTableExportContext();
            HookHandler hookHandler = BdfServerUtils.getHookHandler(this.bdfServer, null, "ScrutariExport");
            ScrutariExportEngine scrutariExportEngine = ScrutariExportEngine.build(this.scrutariExportDef, LangsUtils.toArray(this.bdfServer.getLangConfiguration().getWorkingLangs()), extractionContext, tableExportContext, this.bdfServer.getThesaurusLangChecker(), hookHandler, BdfServerUtils.resolveSelectionOptions(this.bdfServer, this.scrutariExportDef.getSelectionOptions()));
            scrutariExportEngine.run(bufwriter, 0, true);
        }
    }
}

