/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.providers;

import fr.exemole.bdfserver.api.instruction.OutputParameters;
import fr.exemole.bdfserver.api.providers.JsonProducerProvider;
import java.util.ArrayList;
import java.util.List;
import net.mapeadores.util.json.JsonProducer;
import net.mapeadores.util.logging.ErrorMessageException;

public class MultiJsonProducerProviderBuilder {
    private List<JsonProducerProvider> providerList = new ArrayList<JsonProducerProvider>();

    public void addJsonProducerProvider(JsonProducerProvider jsonProducerProvider) {
        if (jsonProducerProvider instanceof MultiJsonProducerProvider) {
            JsonProducerProvider[] array = ((MultiJsonProducerProvider)jsonProducerProvider).array;
            int length = array.length;
            for (int i = 0; i < length; ++i) {
                this.providerList.add(array[i]);
            }
        } else {
            this.providerList.add(jsonProducerProvider);
        }
    }

    public JsonProducerProvider toJsonProducerProvider() {
        int size = this.providerList.size();
        return new MultiJsonProducerProvider(this.providerList.toArray(new JsonProducerProvider[size]));
    }

    private static class MultiJsonProducerProvider
    implements JsonProducerProvider {
        private JsonProducerProvider[] array;

        private MultiJsonProducerProvider(JsonProducerProvider[] array) {
            this.array = array;
        }

        @Override
        public JsonProducer getJsonProducer(OutputParameters parameters) throws ErrorMessageException {
            int length = this.array.length;
            for (int i = 0; i < length; ++i) {
                JsonProducer jsonProducer = this.array[i].getJsonProducer(parameters);
                if (jsonProducer == null) continue;
                return jsonProducer;
            }
            return null;
        }
    }
}

