/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.menu;

import fr.exemole.bdfserver.api.menu.MenuGroup;
import fr.exemole.bdfserver.api.menu.MenuNode;
import fr.exemole.bdfserver.tools.menu.MenuUtils;
import java.util.ArrayList;
import java.util.List;
import net.mapeadores.util.localisation.LocalisationUtils;
import net.mapeadores.util.localisation.Message;

public class MenuGroupBuilder {
    private final String id;
    private final List<MenuNode> menuNodeList = new ArrayList<MenuNode>();
    private String title;
    private Message titleMessage;

    public MenuGroupBuilder(String id) {
        this.id = id;
    }

    public MenuGroupBuilder(String id, String title) {
        this.id = id;
        this.title = title;
    }

    public MenuGroupBuilder setTitle(String title) {
        this.title = title;
        return this;
    }

    public MenuGroupBuilder setTitleMessage(Message titleMessage) {
        this.titleMessage = titleMessage;
        return this;
    }

    public MenuGroupBuilder setTitleMessage(String messageKey, Object ... messageValues) {
        this.titleMessage = LocalisationUtils.toMessage(messageKey, messageValues);
        return this;
    }

    public MenuGroupBuilder addMenuNode(MenuNode menuNode) {
        this.menuNodeList.add(menuNode);
        return this;
    }

    public MenuGroup toMenuGroup() {
        String finalTitle = this.title;
        if (finalTitle == null) {
            finalTitle = this.titleMessage != null ? this.titleMessage.getMessageKey() : "";
        }
        List<MenuNode> list = MenuUtils.wrap(this.menuNodeList.toArray(new MenuNode[this.menuNodeList.size()]));
        return new InternalMenuGroup(this.id, finalTitle, this.titleMessage, list);
    }

    private static class InternalMenuGroup
    implements MenuGroup {
        private final String id;
        private final String title;
        private final Message titleMessage;
        private final List<MenuNode> list;

        private InternalMenuGroup(String id, String title, Message titleMessage, List<MenuNode> list) {
            this.id = id;
            this.title = title;
            this.titleMessage = titleMessage;
            this.list = list;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public Message getTitleMessage() {
            return this.titleMessage;
        }

        @Override
        public String getTitle() {
            return this.title;
        }

        @Override
        public List<MenuNode> getMenuNodeList() {
            return this.list;
        }
    }
}

